/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.integration.jdt.gwt.build.ui;

import com.github.sdbg.integration.jdt.gwt.build.GWTSDMProperties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class GWTSDMPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Button recompileEnabledCheck;
    private Text codeServerHostText;
    private Text codeServerPortText;
    private Text moduleNamesText;
    private Button[] hotCodeReplacePolicyRadio;

    public String getErrorMessage() {
        if (this.recompileEnabledCheck.getSelection()) {
            int port;
            block8: {
                if (this.codeServerHostText.getText().trim().length() == 0) {
                    return "Code Server Host cannot be empty";
                }
                if (this.codeServerPortText.getText().trim().length() == 0) {
                    return "Code Server Port cannot be empty";
                }
                if (this.moduleNamesText.getText().trim().length() == 0) {
                    return "At least one GWT Module should be specified";
                }
                try {
                    port = Integer.parseInt(this.codeServerPortText.getText().trim());
                    if (port >= 0) break block8;
                    return "Code Server Port cannot be less than 0";
                }
                catch (Exception e) {
                    return "Invalid Code Server Port number: " + e.getMessage();
                }
            }
            if (port > 65535) {
                return "Code Server Port cannot be greater than less than 65535";
            }
        }
        return null;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public boolean performOk() {
        this.applyChanges();
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        try {
            Composite contents = new Composite(parent, 0);
            contents.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).create());
            GWTSDMProperties properties = this.getProperties();
            this.recompileEnabledCheck = new Button(contents, 32);
            this.recompileEnabledCheck.setText("Enable automatic GWT SDM recompilation during project build");
            this.recompileEnabledCheck.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
            this.recompileEnabledCheck.setSelection(properties.isRecompileEnabled());
            this.recompileEnabledCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    GWTSDMPropertyPage.this.updateControls();
                    GWTSDMPropertyPage.this.validate();
                }
            });
            Group codeServerGroup = new Group(contents, 0);
            codeServerGroup.setText("Code Server");
            codeServerGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
            codeServerGroup.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 128).grab(true, false).create());
            Label label = new Label((Composite)codeServerGroup, 0);
            label.setLayoutData((Object)new GridData());
            label.setText("Host: ");
            this.codeServerHostText = new Text((Composite)codeServerGroup, 2048);
            this.codeServerHostText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
            this.codeServerHostText.setText(properties.getCodeServerHost());
            this.codeServerHostText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    GWTSDMPropertyPage.this.validate();
                }
            });
            label = new Label((Composite)codeServerGroup, 0);
            label.setLayoutData((Object)new GridData());
            label.setText("Port: ");
            this.codeServerPortText = new Text((Composite)codeServerGroup, 2048);
            this.codeServerPortText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(60, -1).create());
            this.codeServerPortText.setText(Integer.toString(properties.getCodeServerPort()));
            this.codeServerPortText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    GWTSDMPropertyPage.this.validate();
                }
            });
            Group gwtModulesGroup = new Group(contents, 0);
            gwtModulesGroup.setText("GWT Modules");
            gwtModulesGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).create());
            gwtModulesGroup.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 128).grab(true, false).create());
            this.moduleNamesText = new Text((Composite)gwtModulesGroup, 2048);
            this.moduleNamesText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
            this.moduleNamesText.setText(properties.getModuleNames());
            this.moduleNamesText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    GWTSDMPropertyPage.this.validate();
                }
            });
            label = new Label((Composite)gwtModulesGroup, 64);
            label.setLayoutData((Object)GridDataFactory.swtDefaults().align(131072, 128).create());
            label.setText("(a comma-separated list of module names)");
            Group hotCodeReplacePolicyGroup = new Group(contents, 0);
            hotCodeReplacePolicyGroup.setText("Hot Code Replace Policy");
            hotCodeReplacePolicyGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).create());
            hotCodeReplacePolicyGroup.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 128).grab(true, false).create());
            this.hotCodeReplacePolicyRadio = new Button[GWTSDMProperties.HotCodeReplacePolicy.values().length];
            int count = 0;
            GWTSDMProperties.HotCodeReplacePolicy[] hotCodeReplacePolicyArray = GWTSDMProperties.HotCodeReplacePolicy.values();
            int n = hotCodeReplacePolicyArray.length;
            int n2 = 0;
            while (n2 < n) {
                GWTSDMProperties.HotCodeReplacePolicy policy = hotCodeReplacePolicyArray[n2];
                Button radio = new Button((Composite)hotCodeReplacePolicyGroup, 16);
                radio.setText(policy.getDescription());
                radio.setData(GWTSDMProperties.HotCodeReplacePolicy.class.getName(), (Object)policy);
                radio.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
                radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        GWTSDMPropertyPage.this.validate();
                    }
                });
                this.hotCodeReplacePolicyRadio[count++] = radio;
                ++n2;
            }
            hotCodeReplacePolicyArray = this.hotCodeReplacePolicyRadio;
            n = this.hotCodeReplacePolicyRadio.length;
            n2 = 0;
            while (n2 < n) {
                GWTSDMProperties.HotCodeReplacePolicy radio = hotCodeReplacePolicyArray[n2];
                if (radio.getData(GWTSDMProperties.HotCodeReplacePolicy.class.getName()) == properties.getHotCodeReplacePolicy()) {
                    radio.setSelection(true);
                }
                ++n2;
            }
            label = new Label((Composite)hotCodeReplacePolicyGroup, 64);
            label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(700, -1).create());
            label.setText("\nNote:\n- For Hot Code Replace to work, you need an active SDBG debug session\n- Chrome Live Edit will likely crash your browser with anything but the smallest GWT project");
            this.updateControls();
            this.validate();
            return contents;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected void performApply() {
        this.applyChanges();
        super.performApply();
    }

    protected void performDefaults() {
        this.recompileEnabledCheck.setSelection(false);
        this.codeServerHostText.setText("localhost");
        this.codeServerPortText.setText(Integer.toString(9876));
        this.moduleNamesText.setText("");
        Button[] buttonArray = this.hotCodeReplacePolicyRadio;
        int n = this.hotCodeReplacePolicyRadio.length;
        int n2 = 0;
        while (n2 < n) {
            Button radio = buttonArray[n2];
            if (radio.getData(GWTSDMProperties.HotCodeReplacePolicy.class.getName()) == GWTSDMProperties.DEFVALUE_HOT_CODE_REPLACE_POLICY) {
                radio.setSelection(true);
            }
            ++n2;
        }
        this.updateControls();
        super.performDefaults();
    }

    private void applyChanges() {
        try {
            GWTSDMProperties properties = this.getProperties();
            properties.setRecompileEnabled(this.recompileEnabledCheck.getSelection());
            properties.setCodeServerHost(this.codeServerHostText.getText().trim());
            properties.setCodeServerPort(Integer.parseInt(this.codeServerPortText.getText().trim()));
            properties.setModuleNames(this.moduleNamesText.getText().trim());
            Button[] buttonArray = this.hotCodeReplacePolicyRadio;
            int n = this.hotCodeReplacePolicyRadio.length;
            int n2 = 0;
            while (n2 < n) {
                Button radio = buttonArray[n2];
                if (radio.getSelection()) {
                    properties.setHotCodeReplacePolicy((GWTSDMProperties.HotCodeReplacePolicy)((Object)radio.getData(GWTSDMProperties.HotCodeReplacePolicy.class.getName())));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private GWTSDMProperties getProperties() {
        return new GWTSDMProperties((IProject)this.getElement());
    }

    private void updateControls() {
        boolean enabled = this.recompileEnabledCheck.getSelection();
        this.codeServerHostText.setEnabled(enabled);
        this.codeServerPortText.setEnabled(enabled);
        this.moduleNamesText.setEnabled(enabled);
        Button[] buttonArray = this.hotCodeReplacePolicyRadio;
        int n = this.hotCodeReplacePolicyRadio.length;
        int n2 = 0;
        while (n2 < n) {
            Button radio = buttonArray[n2];
            radio.setEnabled(enabled);
            ++n2;
        }
    }

    private void validate() {
        this.setErrorMessage(this.getErrorMessage());
        this.setValid(this.isValid());
    }
}

