/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.integration.jdt.gwt.build;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class GWTSDMProperties {
    private static final QualifiedName PROPERTY_RECOMPILE_ENABLED = new QualifiedName("com.github.sdbg.integration.jdt", "recompileEnabled");
    private static final QualifiedName PROPERTY_CODE_SERVER_HOST = new QualifiedName("com.github.sdbg.integration.jdt", "codeServerHost");
    private static final QualifiedName PROPERTY_CODE_SERVER_PORT = new QualifiedName("com.github.sdbg.integration.jdt", "codeServerPort");
    private static final QualifiedName PROPERTY_MODULE_NAMES = new QualifiedName("com.github.sdbg.integration.jdt", "moduleName");
    private static final QualifiedName PROPERTY_HOT_CODE_REPLACE_POLICY = new QualifiedName("com.github.sdbg.integration.jdt", "hotCodeReplacePolicy");
    public static final String DEFVALUE_CODE_SERVER_HOST = "localhost";
    public static final String DEFVALUE_MODULE_NAMES = "";
    public static final boolean DEFVALUE_RECOMPILE_ENABLED = false;
    public static final int DEFVALUE_CODE_SERVER_PORT = 9876;
    public static final HotCodeReplacePolicy DEFVALUE_HOT_CODE_REPLACE_POLICY = HotCodeReplacePolicy.DISABLED;
    private IProject project;

    public GWTSDMProperties(IProject project) {
        this.project = project;
    }

    public String getCodeServerHost() throws CoreException {
        return this.getProperty(PROPERTY_CODE_SERVER_HOST, DEFVALUE_CODE_SERVER_HOST);
    }

    public int getCodeServerPort() throws CoreException {
        return Integer.parseInt(this.getProperty(PROPERTY_CODE_SERVER_PORT, Integer.toString(9876)));
    }

    public HotCodeReplacePolicy getHotCodeReplacePolicy() throws CoreException {
        try {
            return HotCodeReplacePolicy.valueOf(this.getProperty(PROPERTY_HOT_CODE_REPLACE_POLICY, DEFVALUE_HOT_CODE_REPLACE_POLICY.toString()));
        }
        catch (Exception exception) {
            return DEFVALUE_HOT_CODE_REPLACE_POLICY;
        }
    }

    public String getModuleNames() throws CoreException {
        return this.getProperty(PROPERTY_MODULE_NAMES, DEFVALUE_MODULE_NAMES);
    }

    public boolean isRecompileEnabled() throws CoreException {
        return Boolean.parseBoolean(this.getProperty(PROPERTY_RECOMPILE_ENABLED, Boolean.toString(false)));
    }

    public void setCodeServerHost(String value) throws CoreException {
        this.setProperty(PROPERTY_CODE_SERVER_HOST, value);
    }

    public void setCodeServerPort(Integer value) throws CoreException {
        this.setProperty(PROPERTY_CODE_SERVER_PORT, value != null ? value.toString() : null);
    }

    public void setHotCodeReplacePolicy(HotCodeReplacePolicy value) throws CoreException {
        this.setProperty(PROPERTY_HOT_CODE_REPLACE_POLICY, value != null ? value.toString() : null);
    }

    public void setModuleNames(String value) throws CoreException {
        this.setProperty(PROPERTY_MODULE_NAMES, value);
    }

    public void setRecompileEnabled(Boolean value) throws CoreException {
        this.setProperty(PROPERTY_RECOMPILE_ENABLED, value != null ? value.toString() : null);
    }

    private String getProperty(QualifiedName name, String defaultValue) throws CoreException {
        String value = this.project.getPersistentProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private void setProperty(QualifiedName name, String value) throws CoreException {
        this.project.setPersistentProperty(name, value);
    }

    public static enum HotCodeReplacePolicy {
        DISABLED("Disabled"),
        RELOAD_PAGE("Reload the page hosting the module"),
        CHROME_LIVE_EDIT("(EXPERIMENTAL) Upload the recompiled module script via Chrome LiveEdit");

        private String description;

        private HotCodeReplacePolicy(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

