/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.integration.jdt.gwt.build;

import com.github.sdbg.debug.core.model.IDOMResourceReference;
import com.github.sdbg.debug.core.model.IDOMResourceTracker;
import com.github.sdbg.debug.core.model.IDOMResources;
import com.github.sdbg.integration.jdt.gwt.build.GWTSDMCodeServerAPI;
import com.github.sdbg.integration.jdt.gwt.build.GWTSDMProperties;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.json.JSONException;

public class GWTSDMDOMResourceTracker
implements IDOMResourceTracker {
    private static Collection<GWTSDMDOMResourceTracker> trackers = new HashSet<GWTSDMDOMResourceTracker>();
    private IProject project;
    private IDOMResources domResources;

    public static Collection<GWTSDMDOMResourceTracker> getInitialized() {
        return new HashSet<GWTSDMDOMResourceTracker>(trackers);
    }

    public void dispose() {
        this.project = null;
        this.domResources = null;
        trackers.remove(this);
    }

    public IProject getProject() {
        return this.project;
    }

    public void initialize(IProject project, IDOMResources domResources) {
        this.project = project;
        this.domResources = domResources;
        trackers.add(this);
    }

    public void uploadLatestScript(GWTSDMProperties properties, GWTSDMCodeServerAPI codeServerAPI) throws MalformedURLException, IOException, JSONException, CoreException {
        String modulePath = String.valueOf(codeServerAPI.getModule()) + "-0.js";
        block8: for (IDOMResourceReference ref : this.domResources.getResources()) {
            if (ref.getType() != IDOMResourceReference.Type.SCRIPT || !ref.getUrl().equals(modulePath)) continue;
            switch (properties.getHotCodeReplacePolicy()) {
                case DISABLED: {
                    break;
                }
                case RELOAD_PAGE: {
                    this.domResources.reload();
                    break;
                }
                case CHROME_LIVE_EDIT: {
                    Reader script = codeServerAPI.getCompiledScript();
                    if (script == null) continue block8;
                    try {
                        this.domResources.uploadNewSource(ref, script);
                        continue block8;
                    }
                    finally {
                        script.close();
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown hot code replace policy: " + (Object)((Object)properties.getHotCodeReplacePolicy()));
                }
            }
        }
    }
}

