/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.integration.jdt.gwt.build;

import com.github.sdbg.utilities.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class GWTSDMCodeServerAPI {
    private URI codeServerUri;
    private String module;

    public GWTSDMCodeServerAPI(URI codeServerUri, String module) {
        this.codeServerUri = codeServerUri;
        this.module = module;
    }

    public URI getCodeServerUri() {
        return this.codeServerUri;
    }

    public Reader getCompiledScript() throws MalformedURLException, IOException, JSONException {
        String[] lines;
        String compilationMappings = this.getString(URIUtil.append((URI)URIUtil.append((URI)this.codeServerUri, (String)this.module), (String)"compilation-mappings.txt"));
        if (compilationMappings != null && (lines = compilationMappings.split("\\n")).length > 0) {
            String scriptName = lines[0].trim();
            return this.openReader(URIUtil.append((URI)URIUtil.append((URI)this.codeServerUri, (String)this.module), (String)scriptName));
        }
        return null;
    }

    public URI getLogUri() throws MalformedURLException, IOException, JSONException {
        return URIUtil.append((URI)URIUtil.append((URI)this.codeServerUri, (String)"/log"), (String)this.module);
    }

    public String getModule() {
        return this.module;
    }

    public JSONObject progress() throws MalformedURLException, IOException, JSONException {
        return this.call(URIUtil.append((URI)this.codeServerUri, (String)"/progress"));
    }

    public JSONObject recompile(IProgressMonitor monitor) throws MalformedURLException, IOException, JSONException {
        final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask("Running GWT SDM Recompiler", 1);
        try {
            JSONObject jSONObject;
            final boolean[] exitFlag = new boolean[1];
            final Object syncMonitor = new Object();
            Thread progressThread = new Thread("GWT SDM Recompiler Progress"){

                @Override
                public synchronized void run() {
                    try {
                        GWTSDMCodeServerAPI.this.trackProgress(subMonitor, syncMonitor, exitFlag);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            progressThread.start();
            try {
                jSONObject = this.recompile(this.module);
                exitFlag[0] = true;
            }
            catch (Throwable throwable) {
                exitFlag[0] = true;
                try {
                    progressThread.join();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                throw throwable;
            }
            try {
                progressThread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return jSONObject;
        }
        finally {
            subMonitor.worked(1);
            subMonitor.done();
        }
    }

    public JSONObject recompile(String module) throws MalformedURLException, IOException, JSONException {
        return this.call(URIUtil.append((URI)this.codeServerUri, (String)("/recompile/" + module)));
    }

    private JSONObject call(URI uri) throws MalformedURLException, IOException, JSONException {
        return new JSONObject(this.getString(uri));
    }

    private String getString(URI uri) throws MalformedURLException, IOException, JSONException {
        Reader reader = this.openReader(uri);
        if (reader != null) {
            try {
                String string = Streams.load((Reader)reader);
                return string;
            }
            finally {
                reader.close();
            }
        }
        return null;
    }

    private HttpURLConnection openConnection(URI uri) throws MalformedURLException, IOException, JSONException {
        HttpURLConnection con = (HttpURLConnection)uri.toURL().openConnection();
        con.setDoOutput(false);
        con.setDoInput(true);
        con.setRequestMethod("GET");
        con.connect();
        int retcode = con.getResponseCode();
        if (retcode < 200 || retcode > 299) {
            throw new IOException("Received HTTP Response " + retcode);
        }
        return con;
    }

    private Reader openReader(URI uri) throws MalformedURLException, IOException, JSONException {
        HttpURLConnection con = this.openConnection(uri);
        InputStream in = con.getInputStream();
        if (in != null) {
            String contentEncoding = con.getContentEncoding();
            return contentEncoding != null ? new InputStreamReader(con.getInputStream(), contentEncoding) : new InputStreamReader(con.getInputStream());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackProgress(SubMonitor progressMonitor, Object syncMonitor, boolean[] exitFlag) throws InterruptedException {
        Object object = syncMonitor;
        synchronized (object) {
            long time = System.currentTimeMillis();
            while (!exitFlag[0]) {
                long newTime = System.currentTimeMillis();
                if (newTime - time >= 500L) {
                    time = newTime;
                    try {
                        String module;
                        JSONObject progress = this.progress();
                        if (!"compiling".equals(progress.getString("status"))) break;
                        String message = progress.getString("message");
                        if (message == null) {
                            message = "Compiling";
                        }
                        if ((module = progress.getString("inputModule")) == null) {
                            module = this.getModule();
                        }
                        progressMonitor.subTask(String.valueOf(message) + " module " + module);
                        progressMonitor.setWorkRemaining(10000);
                    }
                    catch (IOException iOException) {
                        break;
                    }
                    catch (JSONException jSONException) {
                        break;
                    }
                }
                syncMonitor.wait(100L);
            }
        }
    }
}

