/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.integration.jdt.gwt.build;

import com.github.sdbg.debug.core.SDBGDebugCorePlugin;
import com.github.sdbg.integration.jdt.SDBGJDTIntegrationPlugin;
import com.github.sdbg.integration.jdt.gwt.build.GWTSDMCodeServerAPI;
import com.github.sdbg.integration.jdt.gwt.build.GWTSDMDOMResourceTracker;
import com.github.sdbg.integration.jdt.gwt.build.GWTSDMProperties;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.json.JSONException;
import org.json.JSONObject;

public class GWTSDMBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "com.github.sdbg.integration.jdt.gwtsdmbuilder";
    private static final String MARKER_TYPE = "com.github.sdbg.integration.jdt.gwtsdmmarker";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.getProject().deleteMarkers(MARKER_TYPE, true, 2);
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        GWTSDMProperties properties = new GWTSDMProperties(this.getProject());
        if (!properties.isRecompileEnabled()) {
            return;
        }
        this.getProject().deleteMarkers(MARKER_TYPE, true, 2);
        String[] modules = properties.getModuleNames().split("\\s\\,\\;");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask("Running GWT SDM Recompiler", modules.length);
        try {
            int i = 0;
            while (i < modules.length) {
                GWTSDMCodeServerAPI codeServerAPI = this.getCodeServerAPI(properties, modules[i].trim());
                try {
                    JSONObject result = codeServerAPI.recompile((IProgressMonitor)subMonitor.newChild(1));
                    if (!"ok".equals(result.getString("status"))) {
                        URI logUri = codeServerAPI.getLogUri();
                        IMarker marker = this.getProject().createMarker(MARKER_TYPE);
                        marker.setAttribute("message", (Object)("GWT SDM recompilation failed for module " + codeServerAPI.getModule() + ". Check your Code Server log (" + logUri.toASCIIString() + ")."));
                        marker.setAttribute("severity", 2);
                    } else {
                        this.notifyBuildCompleted(properties, codeServerAPI);
                    }
                }
                catch (ConnectException connectException) {
                    SDBGDebugCorePlugin.logInfo((String)("Code Server " + codeServerAPI.getCodeServerUri().toString() + " seems to be down. Skipping GWT SDM recompilation for module " + codeServerAPI.getModule()));
                }
                catch (JSONException e) {
                    throw SDBGJDTIntegrationPlugin.wrapError((Exception)((Object)e));
                }
                catch (MalformedURLException e) {
                    throw SDBGJDTIntegrationPlugin.wrapError(e);
                }
                catch (IOException e) {
                    throw SDBGJDTIntegrationPlugin.wrapError(e);
                }
                ++i;
            }
        }
        finally {
            subMonitor.done();
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        this.fullBuild(monitor);
    }

    private GWTSDMCodeServerAPI getCodeServerAPI(GWTSDMProperties properties, String moduleName) {
        try {
            return new GWTSDMCodeServerAPI(new URI("http", null, properties.getCodeServerHost(), properties.getCodeServerPort(), "/", null, null), moduleName);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void notifyBuildCompleted(GWTSDMProperties properties, GWTSDMCodeServerAPI codeServerAPI) throws MalformedURLException, IOException, JSONException, CoreException {
        if (properties.getHotCodeReplacePolicy() != GWTSDMProperties.HotCodeReplacePolicy.DISABLED) {
            for (GWTSDMDOMResourceTracker tracker : GWTSDMDOMResourceTracker.getInitialized()) {
                if (this.getProject() == null || tracker.getProject() == null || !this.getProject().getName().equals(tracker.getProject().getName())) continue;
                tracker.uploadLatestScript(properties, codeServerAPI);
            }
        }
    }
}

