/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.integration.jdt.gwt;

import com.github.sdbg.debug.core.SDBGDebugCorePlugin;
import com.github.sdbg.debug.core.model.ISDBGLogicalStructureTypeExtensions;
import com.github.sdbg.debug.core.model.ISDBGValue;
import com.github.sdbg.debug.core.model.ISDBGVariable;
import com.github.sdbg.debug.core.util.DecoratingSDBGValue;
import com.github.sdbg.debug.core.util.DecoratingSDBGVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ILogicalStructureTypeDelegate;
import org.eclipse.debug.core.model.ILogicalStructureTypeDelegate2;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class GWTSDMStructureType
implements ILogicalStructureTypeDelegate,
ILogicalStructureTypeDelegate2,
ISDBGLogicalStructureTypeExtensions {
    public String getDescription(IValue value) {
        return "GWT SuperDevMode";
    }

    public ISDBGValue getLogicalStructure(IValue value) throws DebugException {
        ISDBGValue sValue = (ISDBGValue)value;
        if (sValue instanceof GWTSDMValue || this.isExcludedFromLogicalStructure((IValue)sValue)) {
            return sValue;
        }
        boolean javaObject = this.isJavaObject(sValue);
        if (javaObject || sValue.isScope()) {
            ArrayList<IVariable> translated = new ArrayList<IVariable>();
            if (javaObject) {
                this.fetchAllJavaFields(value, translated, new HashSet<String>());
            } else {
                IVariable[] iVariableArray = value.getVariables();
                int n = iVariableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IVariable var = iVariableArray[n2];
                    boolean hasLogicalStructure = this.providesLogicalStructure(var.getValue());
                    boolean hasGWTSuffix = this.hasGWTSuffix(var.getName());
                    if (hasLogicalStructure || hasGWTSuffix) {
                        translated.add((IVariable)new GWTSDMVariable(hasGWTSuffix ? this.removeGWTSuffix(var.getName()) : var.getName(), (ISDBGVariable)var));
                    } else {
                        translated.add(var);
                    }
                    ++n2;
                }
            }
            return new GWTSDMValue(javaObject, sValue, translated.toArray(new IVariable[0]));
        }
        Long longValue = this.getLong(sValue);
        if (longValue != null) {
            return new GWTSDMLong(sValue, longValue);
        }
        return sValue;
    }

    public String getVariableName(IVariable variable) throws DebugException {
        ISDBGVariable svar;
        String name = variable.getName();
        if (variable instanceof ISDBGVariable && (svar = (ISDBGVariable)variable).isLocal() && this.hasGWTSuffix(name)) {
            name = this.removeGWTSuffix(name);
        }
        return name;
    }

    public boolean isValueDetailStringComputedByLogicalStructure(IValue value) throws DebugException {
        if (value instanceof ISDBGValue && !(value instanceof GWTSDMValue)) {
            ISDBGValue sval = (ISDBGValue)value;
            return !sval.isScope() && this.getLong(sval) != null;
        }
        return false;
    }

    public boolean isValueStringComputedByLogicalStructure(IValue value) throws DebugException {
        if (value instanceof ISDBGValue && !(value instanceof GWTSDMValue) && !this.isExcludedFromLogicalStructure(value)) {
            ISDBGValue sval = (ISDBGValue)value;
            return !sval.isScope() && (this.isJavaObject(sval) || this.getLong(sval) != null);
        }
        return false;
    }

    public boolean providesLogicalStructure(IValue value) {
        try {
            return value instanceof ISDBGValue && !(value instanceof GWTSDMValue) && !this.isExcludedFromLogicalStructure(value);
        }
        catch (DebugException e) {
            SDBGDebugCorePlugin.logError((Throwable)e);
            return false;
        }
    }

    private void fetchAllJavaFields(IValue value, List<IVariable> variables, Collection<String> visited) throws DebugException {
        IVariable[] iVariableArray = value.getVariables();
        int n = iVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable var = iVariableArray[n2];
            String name = var.getName();
            if (!(!this.hasGWTSuffix(name) || name.equals("$H") || this.isGWTInit(name) || this.isGWTClass(name) || this.isGWTCastableTypeMap(name) || var.getValue() != null && ((ISDBGValue)var.getValue()).isFunction() || visited.contains(name = this.removeGWTSuffix(name)))) {
                visited.add(name);
                variables.add((IVariable)new GWTSDMVariable(name, (ISDBGVariable)var));
            }
            ++n2;
        }
        IVariable protoVar = this.getOwnProperty(value, "__proto__");
        if (protoVar != null) {
            IValue protoValue = protoVar.getValue();
            if (value != null && this.isJavaClass((ISDBGValue)protoValue)) {
                this.fetchAllJavaFields(protoValue, variables, visited);
            }
        }
    }

    private Long getLong(ISDBGValue value) throws DebugException {
        if (!value.isObject() || value.isScope()) {
            return null;
        }
        IVariable[] variables = value.getVariables();
        if (variables.length != 4) {
            return null;
        }
        long l = 0L;
        IVariable[] iVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable var = iVariableArray[n2];
            String name = var.getName();
            if (!name.equals("__proto__")) {
                if (!(name.equals("h") || name.equals("m") || name.equals("l"))) {
                    return null;
                }
                IValue v = var.getValue();
                if (!(value instanceof ISDBGValue)) {
                    return null;
                }
                ISDBGValue sv = (ISDBGValue)v;
                Object rawValue = sv.getRawValue();
                if (!(rawValue instanceof Number)) {
                    return null;
                }
                long ll = ((Number)rawValue).longValue();
                l |= ll << (name.equals("h") ? 44 : (name.equals("m") ? 22 : 0));
            }
            ++n2;
        }
        return l;
    }

    private IVariable getOwnProperty(IValue value, Matcher matcher) throws DebugException {
        IVariable[] iVariableArray = value.getVariables();
        int n = iVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable var = iVariableArray[n2];
            if (matcher.matches(var.getName())) {
                return var;
            }
            ++n2;
        }
        return null;
    }

    private IVariable getOwnProperty(IValue value, String property) throws DebugException {
        return this.getOwnProperty(value, new ExactMatcher(property));
    }

    private boolean hasGWTSuffix(String name) {
        return name.endsWith("_g$");
    }

    private boolean hasOwnProperty(IValue value, Matcher matcher) throws DebugException {
        return this.getOwnProperty(value, matcher) != null;
    }

    private boolean isExcludedFromLogicalStructure(IValue value) throws DebugException {
        if (!(value instanceof ISDBGValue)) {
            return false;
        }
        String excludeFromLogicalStructureStr = SDBGDebugCorePlugin.getPlugin().getExcludeFromLogicalStructure();
        if (excludeFromLogicalStructureStr != null && excludeFromLogicalStructureStr.trim().length() > 0) {
            return Pattern.matches(excludeFromLogicalStructureStr, value.getReferenceTypeName());
        }
        return false;
    }

    private boolean isGWTCastableTypeMap(String name) {
        return this.hasGWTSuffix(name) && name.startsWith("castableTypeMap_");
    }

    private boolean isGWTClass(String name) {
        return name.equals("___clazz$") || this.hasGWTSuffix(name) && name.startsWith("___clazz_");
    }

    private boolean isGWTInit(String name) {
        return name.equals("$init") || this.hasGWTSuffix(name) && name.startsWith("$init_");
    }

    private boolean isJavaClass(ISDBGValue value) throws DebugException {
        return value.isObject() && this.hasOwnProperty((IValue)value, new Matcher(){

            @Override
            public boolean matches(String name) {
                return GWTSDMStructureType.this.isGWTClass(name);
            }
        });
    }

    private boolean isJavaObject(ISDBGValue value) throws DebugException {
        if (value.isObject() && !value.isScope()) {
            IVariable proto = this.getOwnProperty((IValue)value, "__proto__");
            return proto instanceof ISDBGVariable && this.isJavaClass((ISDBGValue)proto.getValue());
        }
        return false;
    }

    private String removeGWTSuffix(String name) {
        if (name.length() > 3) {
            int pos = name.lastIndexOf(95, name.length() - 4);
            if (pos > 0) {
                return name.substring(0, pos);
            }
            return name.substring(0, name.length() - 3);
        }
        return name;
    }

    private static class ExactMatcher
    implements Matcher {
        private String name;

        public ExactMatcher(String name) {
            this.name = name;
        }

        @Override
        public boolean matches(String name) {
            return this.name.equals(name);
        }
    }

    private class GWTSDMLong
    extends GWTSDMValue {
        private Long value;

        public GWTSDMLong(ISDBGValue proxyValue, Long value) {
            super(false, proxyValue, new IVariable[0]);
            this.value = value;
        }

        public void computeDetail(ISDBGValue.IValueCallback callback) {
            callback.detailComputed(this.value.toString());
        }

        @Override
        public String getReferenceTypeName() throws DebugException {
            return "long";
        }

        @Override
        public String getValueString() throws DebugException {
            return this.value.toString();
        }

        public boolean isNumber() {
            return true;
        }

        public boolean isObject() {
            return false;
        }

        public boolean isPrimitive() {
            return true;
        }
    }

    private class GWTSDMValue
    extends DecoratingSDBGValue {
        private boolean javaObject;

        public GWTSDMValue(boolean javaObject, ISDBGValue proxyValue, IVariable[] variables) {
            super(proxyValue, variables);
            this.javaObject = javaObject;
        }

        public String getId() {
            return null;
        }

        public String getReferenceTypeName() throws DebugException {
            String rawReferenceTypeName = super.getReferenceTypeName();
            if (this.javaObject && GWTSDMStructureType.this.hasGWTSuffix(rawReferenceTypeName)) {
                return GWTSDMStructureType.this.removeGWTSuffix(rawReferenceTypeName);
            }
            return rawReferenceTypeName;
        }

        public String getValueString() throws DebugException {
            if (this.javaObject) {
                return this.getReferenceTypeName();
            }
            return super.getValueString();
        }
    }

    private class GWTSDMVariable
    extends DecoratingSDBGVariable {
        private String newName;

        public GWTSDMVariable(String newName, ISDBGVariable proxyVariable) {
            super(proxyVariable);
            this.newName = newName;
        }

        public String getName() throws DebugException {
            return this.newName;
        }

        public String getReferenceTypeName() throws DebugException {
            String rawReferenceTypeName = super.getReferenceTypeName();
            if (!GWTSDMStructureType.this.isExcludedFromLogicalStructure(this.getValue()) && GWTSDMStructureType.this.isJavaObject((ISDBGValue)this.getValue()) && GWTSDMStructureType.this.hasGWTSuffix(rawReferenceTypeName)) {
                return GWTSDMStructureType.this.removeGWTSuffix(rawReferenceTypeName);
            }
            return rawReferenceTypeName;
        }
    }

    private static interface Matcher {
        public boolean matches(String var1);
    }
}

