/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.integration.jdt;

import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardSourcePathProvider;

public class JDTSourcePathProvider
extends StandardSourcePathProvider {
    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject proj = this.getJavaProject(configuration);
        if (proj != null) {
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)proj);
            return entries;
        }
        return new IRuntimeClasspathEntry[0];
    }

    private IJavaProject getJavaProject(ILaunchConfiguration launchConfiguration) throws CoreException {
        SDBGLaunchConfigWrapper conf = new SDBGLaunchConfigWrapper(launchConfiguration);
        IProject project = conf.getProject();
        if (project == null) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        assert (javaProject != null);
        if (javaProject.getProject().exists() && !javaProject.getProject().isOpen()) {
            throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.core", 0, "Project is closed", null));
        }
        if (!javaProject.exists()) {
            throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.core", 0, "Project does not exist", null));
        }
        return javaProject;
    }
}

