/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.integration.jdt;

import com.github.sdbg.debug.core.breakpoints.IBreakpointPathResolver;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;

public class JDTBreakpointPathResolver
implements IBreakpointPathResolver {
    public String getPath(IBreakpoint breakpoint) throws CoreException {
        IJavaBreakpoint bp = (IJavaBreakpoint)breakpoint;
        String path = this.getLocalPath(bp);
        if (path != null) {
            return path;
        }
        String type = bp.getTypeName();
        if (type != null) {
            int innerClassIndex = type.indexOf(36);
            if (innerClassIndex > 0) {
                type = type.substring(0, innerClassIndex);
            }
            return String.valueOf(type.replace('.', '/')) + ".java";
        }
        return null;
    }

    private String getLocalPath(IJavaBreakpoint bp) throws CoreException {
        String type;
        if (bp.getMarker() != null && bp.getMarker().getResource() != null && bp.getMarker().getResource().getType() == 1 && (type = bp.getTypeName()) != null) {
            String pkg = (type.lastIndexOf(46) >= 0 ? String.valueOf(type.substring(0, type.lastIndexOf(46))) + "/" : "").replace('.', '/');
            return String.valueOf(pkg) + bp.getMarker().getResource().getName();
        }
        return null;
    }

    public boolean isSupported(IBreakpoint breakpoint) {
        return breakpoint instanceof IJavaBreakpoint;
    }
}

