/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.integration.jdt;

import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.util.LaunchUtils;
import com.github.sdbg.integration.jdt.SDBGJDTIntegrationPlugin;
import com.google.gdt.eclipse.core.IDebugLaunch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ChromeDebugLaunch
implements IDebugLaunch {
    public void launch(IProject project, String url, String mode) {
        if (project == null || url == null || mode == null) {
            return;
        }
        try {
            ILaunchConfiguration config;
            try {
                config = this.findConfig(project, url);
            }
            catch (OperationCanceledException operationCanceledException) {
                return;
            }
            if (config == null) {
                config = this.createConfig(project, url);
            }
            SDBGLaunchConfigWrapper launchWrapper = new SDBGLaunchConfigWrapper(config);
            launchWrapper.markAsLaunched();
            LaunchUtils.clearConsoles();
            LaunchUtils.launch((ILaunchConfiguration)config, (String)mode);
        }
        catch (CoreException e) {
            SDBGJDTIntegrationPlugin.wrapError((Exception)((Object)e));
        }
    }

    private ILaunchConfiguration chooseConfig(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Select Configuration");
        dialog.setMessage("&Select existing configuration:");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    private ILaunchConfiguration createConfig(IProject project, String url) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("com.github.sdbg.debug.core.chromeLaunchConfig");
        ILaunchConfigurationWorkingCopy launchConfig = type.newInstance(null, manager.generateLaunchConfigurationName(project.getName()));
        SDBGLaunchConfigWrapper launchWrapper = new SDBGLaunchConfigWrapper((ILaunchConfiguration)launchConfig);
        launchWrapper.setApplicationName(project.getFullPath().toString());
        launchWrapper.setProjectName(project.getProject().getName());
        if (url != null) {
            launchWrapper.setUrl(url);
        }
        launchConfig.setMappedResources(new IResource[]{project});
        return launchConfig.doSave();
    }

    private ILaunchConfiguration findConfig(IProject project, String url) throws OperationCanceledException, CoreException {
        List<ILaunchConfiguration> candidateConfigs = Arrays.asList(this.getAssociatedConfigs(project, url));
        int candidateCount = candidateConfigs.size();
        if (candidateCount == 1) {
            return candidateConfigs.get(0);
        }
        if (candidateCount > 1) {
            ILaunchConfiguration result = this.chooseConfig(candidateConfigs);
            if (result != null) {
                return result;
            }
            throw new OperationCanceledException();
        }
        return null;
    }

    private ILaunchConfiguration[] getAssociatedConfigs(IProject project, String url) throws CoreException {
        ArrayList<ILaunchConfiguration> results = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.getConfigurationType());
        int i = 0;
        while (i < configs.length) {
            ILaunchConfiguration config = configs[i];
            if (this.testSimilar(project, url, config)) {
                results.add(config);
            }
            ++i;
        }
        return results.toArray(new ILaunchConfiguration[results.size()]);
    }

    private ILaunchConfigurationType getConfigurationType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        return manager.getLaunchConfigurationType("com.github.sdbg.debug.core.chromeLaunchConfig");
    }

    private boolean testSimilar(IProject project, String url, ILaunchConfiguration config) {
        SDBGLaunchConfigWrapper launchWrapper = new SDBGLaunchConfigWrapper(config);
        IProject otherProject = launchWrapper.getProject();
        String otherUrl = launchWrapper.getUrl();
        return project != null && project.equals((Object)otherProject) && url != null && url.equals(otherUrl);
    }
}

