/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.ui.instrumentation;

import com.github.sdbg.ui.instrumentation.UIInstrumentationBuilder;
import com.github.sdbg.utilities.instrumentation.Instrumentation;
import com.github.sdbg.utilities.instrumentation.InstrumentationBuilder;
import com.github.sdbg.utilities.instrumentation.InstrumentationLevel;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class UIInstrumentation {
    public static UIInstrumentationBuilder builder(Class<?> clazz) {
        return UIInstrumentation.builder(clazz.getSimpleName());
    }

    public static UIInstrumentationBuilder builder(String name) {
        return new AugmentedInformationBuilder(Instrumentation.builder((String)name));
    }

    public static UIInstrumentationBuilder getNullBuilder() {
        return new AugmentedInformationBuilder(Instrumentation.getNullBuilder());
    }

    private static class AugmentedInformationBuilder
    implements UIInstrumentationBuilder {
        private final InstrumentationBuilder builder;

        public AugmentedInformationBuilder(InstrumentationBuilder builder) {
            this.builder = builder;
        }

        public InstrumentationBuilder data(String name, boolean value) {
            this.builder.data(name, value);
            return this;
        }

        public UIInstrumentationBuilder data(String name, long value) {
            this.builder.data(name, value);
            return this;
        }

        public UIInstrumentationBuilder data(String name, String value) {
            this.builder.data(name, value);
            return this;
        }

        public UIInstrumentationBuilder data(String name, String[] value) {
            this.builder.data(name, value);
            return this;
        }

        public InstrumentationLevel getInstrumentationLevel() {
            return this.builder.getInstrumentationLevel();
        }

        public void log() {
            this.builder.log();
        }

        public void log(int minTimeToLog) {
            this.builder.log(minTimeToLog);
        }

        public InstrumentationBuilder metric(String name, boolean value) {
            this.builder.metric(name, value);
            return this;
        }

        public UIInstrumentationBuilder metric(String name, long value) {
            this.builder.metric(name, value);
            return this;
        }

        public UIInstrumentationBuilder metric(String name, String value) {
            this.builder.metric(name, value);
            return this;
        }

        public UIInstrumentationBuilder metric(String name, String[] value) {
            this.builder.metric(name, value);
            return this;
        }

        @Override
        public void record(IResource[] resources) {
            if (resources == null) {
                this.metric("resouces", "null");
                return;
            }
            this.metric("resourcesLength", resources.length);
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource ir = iResourceArray[n2];
                this.data("ResourceName", ir.getName());
                ++n2;
            }
        }

        @Override
        public void record(ISelection selection) {
            if (selection == null) {
                this.metric("Selection", "null");
                return;
            }
            if (selection instanceof IStructuredSelection) {
                this.record((IStructuredSelection)selection);
            } else if (selection instanceof ITextSelection) {
                this.record((ITextSelection)selection);
            } else if (selection != null) {
                this.metric("Selection-Class", selection.getClass().toString());
            }
        }

        @Override
        public void record(IStructuredSelection selection) {
            if (selection == null) {
                this.metric("Selection", "null");
                return;
            }
            this.metric("Selection-Class", selection.getClass().toString());
            Object firstElement = selection.getFirstElement();
            if (firstElement != null) {
                this.metric("Selection-FirstElement", firstElement.getClass().toString());
            }
        }

        @Override
        public void record(ITextSelection selection) {
            if (selection == null) {
                this.metric("Selection", "null");
                return;
            }
            this.metric("Selection-Class", selection.getClass().toString());
            this.metric("Selection-length", selection.getLength());
            this.metric("Selection-startLine", selection.getStartLine());
            this.metric("Selection-endLine", selection.getEndLine());
            this.metric("Selection-offset", selection.getOffset());
            this.data("Selection-text", selection.getText());
        }

        @Override
        public void record(IWorkbenchPage page) {
            if (page == null) {
                this.metric("page", "null");
                return;
            }
            this.metric("type", page.getClass().toString());
            this.data("label", page.getLabel());
            this.record(page.getSelection());
        }

        @Override
        public void record(IWorkbenchPartReference part) {
            if (part == null) {
                this.metric("part", "null");
                return;
            }
            this.metric("type", part.getClass().toString());
            this.data("id", part.getId());
            this.data("partName", part.getPartName());
            this.data("pageTitle", part.getTitle());
            this.metric("isDirty", part.isDirty());
        }

        @Override
        public void record(IWorkbenchWindow window) {
            if (window == null) {
                this.metric("window", "null");
                return;
            }
            this.metric("type", window.getClass().toString());
        }

        public InstrumentationBuilder record(Throwable exception) {
            this.builder.record(exception);
            return this;
        }
    }
}

