/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.view;

import com.github.sdbg.debug.core.SDBGDebugCorePlugin;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;

public class ToggleUseSourceMapsAction
extends Action {
    private IViewPart launchView;

    public ToggleUseSourceMapsAction(IViewPart launchView) {
        super("Use Source Maps", 2);
        this.setImageDescriptor(SDBGDebugUIPlugin.getImageDescriptor("obj16/map_file.png"));
        this.setChecked(SDBGDebugCorePlugin.getPlugin().getUseSourceMaps());
        this.launchView = launchView;
    }

    public void run() {
        IStructuredSelection selection;
        Object obj;
        SDBGDebugCorePlugin.getPlugin().setUseSourceMaps(this.isChecked());
        ISelection sel = this.launchView.getSite().getSelectionProvider().getSelection();
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (obj = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof IStackFrame) {
            IStackFrame frame = (IStackFrame)obj;
            this.fireEvent(new DebugEvent((Object)frame, 2, 16));
        }
    }

    private void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }
}

