/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.view;

import com.github.sdbg.debug.ui.internal.DartUtil;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.objectinspector.ObjectInspectorView;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ShowInspectorAction
extends Action {
    private IDetailPaneContainer selectionProvider;

    public ShowInspectorAction() {
        super("Show Object Inspector", SDBGDebugUIPlugin.getImageDescriptor("obj16/value_show.gif"));
    }

    public synchronized void run() {
        try {
            IStructuredSelection sel = this.selectionProvider.getCurrentSelection();
            if (sel != null && !sel.isEmpty()) {
                Object obj = sel.getFirstElement();
                if (obj instanceof IVariable) {
                    try {
                        obj = ((IVariable)obj).getValue();
                    }
                    catch (DebugException debugException) {}
                }
                if (obj instanceof IValue) {
                    ObjectInspectorView.inspect((IValue)obj);
                    return;
                }
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.github.sdbg.debug.objectInspectorView");
        }
        catch (PartInitException e) {
            DartUtil.logError(e);
        }
    }

    public void setSelectionProvider(IDetailPaneContainer selectionProvider) {
        this.selectionProvider = selectionProvider;
    }
}

