/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.view;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class RemoveLaunchAction
extends Action
implements IDebugContextListener {
    private IDebugContextService contextService;

    public RemoveLaunchAction(IDebugContextService contextService) {
        super("Remove Launch");
        this.contextService = contextService;
        this.setToolTipText("Remove Launch");
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_LCL_REMOVE"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_DLCL_REMOVE"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_ELCL_REMOVE"));
        contextService.addDebugContextListener((IDebugContextListener)this);
        this.setEnabled(false);
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.update(event.getContext());
    }

    public void dispose() {
        this.contextService.removeDebugContextListener((IDebugContextListener)this);
    }

    public synchronized void run() {
        ILaunch terminatable = this.getTerminatable();
        if (terminatable != null) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunch(terminatable);
        }
    }

    private ILaunch getTerminatable() {
        return this.getTerminatable(this.contextService.getActiveContext());
    }

    private ILaunch getTerminatable(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)sel).getFirstElement();
            if (obj instanceof ILaunch) {
                return (ILaunch)obj;
            }
            if (obj instanceof IAdaptable) {
                return (ILaunch)((IAdaptable)obj).getAdapter(ILaunch.class);
            }
        }
        return null;
    }

    private void update(ISelection sel) {
        ILaunch terminatable = this.getTerminatable(sel);
        if (terminatable != null) {
            this.setEnabled(terminatable.isTerminated());
        } else {
            this.setEnabled(false);
        }
    }
}

