/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.view;

import com.github.sdbg.debug.ui.internal.view.RemoveAllBreakpointsAction;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;

public class RemoveAllBreakpointsHandler
extends AbstractHandler
implements IBreakpointListener {
    private RemoveAllBreakpointsAction action;

    public RemoveAllBreakpointsHandler() {
        this.init();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.updateEnablement();
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.updateEnablement();
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.updateEnablement();
    }

    public void dispose() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.removeBreakpointListener((IBreakpointListener)this);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.getRemoveBreakpointsAction().run();
        return null;
    }

    protected void init() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.addBreakpointListener((IBreakpointListener)this);
        this.updateEnablement();
    }

    private RemoveAllBreakpointsAction getRemoveBreakpointsAction() {
        if (this.action == null) {
            this.action = new RemoveAllBreakpointsAction();
        }
        return this.action;
    }

    private void updateEnablement() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
        this.setBaseEnabled(breakpoints.length > 0);
    }
}

