/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.view;

import com.github.sdbg.debug.ui.internal.DartUtil;
import com.github.sdbg.debug.ui.internal.DebugErrorHandler;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RemoveAllBreakpointsAction
extends Action
implements IBreakpointListener {
    public RemoveAllBreakpointsAction() {
        super("Remove All Breakpoints");
        this.setImageDescriptor(SDBGDebugUIPlugin.getImageDescriptor("obj16/rem_all_brk.gif"));
        this.init();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.updateEnablement();
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.updateEnablement();
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.updateEnablement();
    }

    public void run() {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    RemoveAllBreakpointsAction.this.deleteBreakpoints(shell, monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            DartUtil.logError(e);
        }
        catch (InterruptedException e) {
            DartUtil.logError(e);
        }
    }

    protected void deleteBreakpoints(Shell shell, IProgressMonitor monitor) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
        if (breakpoints.length > 0) {
            try {
                DebugUITools.deleteBreakpoints((IBreakpoint[])breakpoints, (Shell)shell, (IProgressMonitor)monitor);
            }
            catch (CoreException exception) {
                DebugErrorHandler.errorDialog(shell, "Error Deleting Breakpoints", exception.toString(), exception);
            }
        }
    }

    protected void dispose() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.removeBreakpointListener((IBreakpointListener)this);
    }

    protected void init() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.addBreakpointListener((IBreakpointListener)this);
        this.updateEnablement();
    }

    private void updateEnablement() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
        this.setEnabled(breakpoints.length > 0);
    }
}

