/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.view;

import com.github.sdbg.debug.ui.internal.DartUtil;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.hover.DebugHover;
import com.github.sdbg.debug.ui.internal.util.DebuggerEditorInput;
import com.github.sdbg.debug.ui.internal.view.DebuggerPatternMatchListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;
import org.eclipse.debug.ui.contexts.ISuspendTriggerListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.views.IViewDescriptor;

public class DebuggerViewManager
implements ILaunchListener,
ISuspendTriggerListener,
IDebugEventSetListener {
    private static DebuggerViewManager manager;
    private static DebugHover hoverHelper;
    private DebuggerPatternMatchListener patternMatchListener = new DebuggerPatternMatchListener();

    static {
        hoverHelper = new DebugHover();
    }

    public static void dispose() {
        if (manager != null) {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)manager);
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)manager);
            manager = null;
        }
    }

    public static DebuggerViewManager getDefault() {
        if (manager == null) {
            manager = new DebuggerViewManager();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)DebuggerViewManager.getDefault());
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)DebuggerViewManager.getDefault());
        }
        return manager;
    }

    DebuggerViewManager() {
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getKind() == 4 && event.getSource() instanceof IProcess) {
                this.attachConsoleListener((IProcess)event.getSource());
            } else if (event.getKind() == 8 && event.getSource() instanceof IDebugTarget) {
                this.handleDebugTargetTerminated((IDebugTarget)event.getSource());
            }
            ++n2;
        }
    }

    public void launchAdded(ILaunch launch) {
        try {
            ISuspendTrigger trigger;
            if (launch.getLaunchConfiguration().getType().getIdentifier().startsWith("com.google") && launch.getLaunchMode().equals("debug") && (trigger = (ISuspendTrigger)launch.getAdapter(ISuspendTrigger.class)) != null) {
                trigger.addSuspendTriggerListener((ISuspendTriggerListener)this);
            }
        }
        catch (CoreException e) {
            DartUtil.logError(e);
        }
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
        try {
            ISuspendTrigger trigger;
            if (launch != null && launch.getLaunchConfiguration() != null && launch.getLaunchMode() != null && launch.getLaunchConfiguration().getType().getIdentifier().startsWith("com.google") && launch.getLaunchMode().equals("debug") && (trigger = (ISuspendTrigger)launch.getAdapter(ISuspendTrigger.class)) != null) {
                trigger.removeSuspendTriggerListener((ISuspendTriggerListener)this);
            }
        }
        catch (CoreException e) {
            DartUtil.logError(e);
        }
    }

    public void suspended(ILaunch launch, Object context) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DebuggerViewManager.this.hasDebuggerView()) {
                    DebuggerViewManager.this.openDebuggerView();
                    IWorkbenchWindow window = SDBGDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                    if (window == null) {
                        window = DebuggerViewManager.this.getWindowWithView("com.github.sdbg.debug.ui.debuggerView");
                    }
                    window.getShell().forceActive();
                    IViewReference viewReference = window.getActivePage().findViewReference("com.github.sdbg.debug.ui.debuggerView");
                    window.getActivePage().activate(viewReference.getPart(true));
                }
            }
        });
    }

    protected void handleDebugTargetTerminated(IDebugTarget target) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DebuggerViewManager.this.closeDebuggerEditors();
            }
        });
    }

    private void attachConsoleListener(IProcess process) {
        IConsole console = DebugUITools.getConsole((IProcess)process);
        if (console instanceof TextConsole) {
            TextConsole textConsole = (TextConsole)console;
            textConsole.addPatternMatchListener((IPatternMatchListener)this.patternMatchListener);
        }
    }

    private void closeDebuggerEditors() {
        if (Display.getDefault().isDisposed()) {
            return;
        }
        if (PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            if (editor != null && editor.getEditorInput() instanceof DebuggerEditorInput) {
                page.closeEditor(editor, false);
            }
            ++n2;
        }
    }

    private IWorkbenchWindow getWindowWithView(String viewId) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            int i = 0;
            while (i < windows.length) {
                IWorkbenchPage[] pages;
                IWorkbenchPage[] iWorkbenchPageArray = pages = windows[i].getPages();
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage page = iWorkbenchPageArray[n2];
                    if (page.findView(viewId) != null) {
                        return windows[i];
                    }
                    ++n2;
                }
                ++i;
            }
        }
        return null;
    }

    private boolean hasDebuggerView() {
        IViewDescriptor[] views;
        IViewDescriptor[] iViewDescriptorArray = views = SDBGDebugUIPlugin.getDefault().getWorkbench().getViewRegistry().getViews();
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            IViewDescriptor view = iViewDescriptorArray[n2];
            if (view.getId().equals("com.github.sdbg.debug.ui.debuggerView")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void openDebuggerView() {
        try {
            IWorkbenchWindow window = SDBGDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                IWorkbenchPage[] pages;
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                if (windows.length > 0 && (pages = windows[0].getPages()).length > 0) {
                    pages[0].showView("com.github.sdbg.debug.ui.debuggerView", null, 1);
                }
            } else {
                window.getActivePage().showView("com.github.sdbg.debug.ui.debuggerView");
            }
        }
        catch (PartInitException e) {
            DartUtil.logError(e);
        }
    }
}

