/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.view;

import com.github.sdbg.debug.ui.internal.DartUtil;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.util.SWTUtil;
import com.github.sdbg.debug.ui.internal.view.BlankSeparator;
import com.github.sdbg.debug.ui.internal.view.DartVariablesView;
import com.github.sdbg.debug.ui.internal.view.ShowBreakpointsAction;
import com.github.sdbg.debug.ui.internal.view.ShowExpressionsAction;
import com.github.sdbg.debug.ui.internal.view.ShowInspectorAction;
import com.github.sdbg.debug.ui.internal.view.ToggleUseSourceMapsAction;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.debug.internal.ui.views.variables.ToggleLogicalStructureAction;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;

public class DebuggerView
extends LaunchView
implements ILaunchesListener {
    public static final String ID = "com.github.sdbg.debug.ui.debuggerView";
    private static final String SASH_WEIGHTS = "sashWeights";
    private ToolBar toolbar;
    private SashForm sashForm;
    private DartVariablesView variablesView;
    private static Image CONNECTED_IMAGE;
    private static Image NOT_CONNECTED_IMAGE;
    private ShowBreakpointsAction showBreakpointsAction;
    private ShowInspectorAction showInspectorAction;
    private ShowExpressionsAction showExpressionsAction;
    private TreeModelViewer treeViewer;
    private IPreferenceStore preferences;
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            DebuggerView.this.doPropertyChange(event);
        }
    };

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(composite);
        this.toolbar = new ToolBar(composite, 256);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.toolbar);
        Label separator = new Label(composite, 258);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)separator);
        this.sashForm = new SashForm(composite, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sashForm);
        super.createPartControl((Composite)this.sashForm);
        ISelectionProvider selProvider = this.getViewSite().getSelectionProvider();
        this.variablesView = new DartVariablesView();
        try {
            this.variablesView.init(this.getViewSite());
        }
        catch (PartInitException ex) {
            DartUtil.logError(ex);
        }
        this.variablesView.createPartControl((Composite)this.sashForm);
        if (this.getViewSite().getSelectionProvider() != selProvider) {
            this.getViewSite().setSelectionProvider(selProvider);
        }
        this.variablesView.becomesVisible();
        this.showInspectorAction.setSelectionProvider((IDetailPaneContainer)this.variablesView);
        this.restoreSashWeights(this.getMemento());
        this.updateSashOrientation(this.sashForm);
        this.sashForm.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                DebuggerView.this.updateSashOrientation(DebuggerView.this.sashForm);
            }
        });
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getMenuManager().removeAll();
        this.configureViewToolBar(actionBars.getToolBarManager());
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        if (CONNECTED_IMAGE == null) {
            NOT_CONNECTED_IMAGE = SDBGDebugUIPlugin.getImage("obj16/debug_exc.gif");
            CONNECTED_IMAGE = SDBGDebugUIPlugin.getImage((ImageDescriptor)new DecorationOverlayIcon(NOT_CONNECTED_IMAGE, SDBGDebugUIPlugin.getImageDescriptor("ovr16/play.png"), 3));
        }
        this.updateConnectionStatus();
    }

    public void dispose() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        this.variablesView.dispose();
        if (this.propertyChangeListener != null) {
            this.getPreferences().removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        super.dispose();
    }

    public void launchesAdded(ILaunch[] launches) {
        this.updateConnectionStatusAsync();
    }

    public void launchesChanged(ILaunch[] launches) {
        this.updateConnectionStatusAsync();
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.updateConnectionStatusAsync();
    }

    public void saveViewerState(IMemento memento) {
        super.saveViewerState(memento);
        int[] weights = this.sashForm.getWeights();
        memento.putString(SASH_WEIGHTS, String.valueOf(weights[0]) + "," + weights[1]);
    }

    protected void configureToolBar(IToolBarManager viewToolBarManager) {
        ToolBarManager manager = new ToolBarManager(this.toolbar);
        manager.add(this.getAction("resume"));
        manager.add(this.getAction("suspend"));
        manager.add((IContributionItem)new BlankSeparator());
        manager.add(this.getAction("step_into"));
        manager.add(this.getAction("step_over"));
        manager.add(this.getAction("step_return"));
        manager.add((IContributionItem)new BlankSeparator());
        manager.add(this.getAction("terminate"));
        manager.update(true);
        this.toolbar.pack();
        this.toolbar.getParent().layout(true);
    }

    protected void configureViewToolBar(IToolBarManager manager) {
        manager.removeAll();
        manager.add((IAction)this.showBreakpointsAction);
        manager.add((IAction)this.showInspectorAction);
        manager.add((IAction)this.showExpressionsAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ToggleLogicalStructureAction((VariablesView)this.variablesView));
        manager.add((IAction)new ToggleUseSourceMapsAction((IViewPart)this));
        manager.update(true);
    }

    protected void createActions() {
        super.createActions();
        this.showBreakpointsAction = new ShowBreakpointsAction();
        this.setAction("showBreakpointsAction", (IAction)this.showBreakpointsAction);
        this.showInspectorAction = new ShowInspectorAction();
        this.setAction("showInspectorAction", (IAction)this.showInspectorAction);
        this.showExpressionsAction = new ShowExpressionsAction();
        this.setAction("showExpressionsAction", (IAction)this.showExpressionsAction);
    }

    protected TreeModelViewer createViewer(Composite parent) {
        TreeModelViewer treeViewer;
        this.preferences = SDBGDebugUIPlugin.getDefault().getCombinedPreferenceStore();
        this.treeViewer = treeViewer = (TreeModelViewer)super.createViewer(parent);
        treeViewer.getTree().setBackgroundMode(2);
        treeViewer.getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                SWTUtil.eraseSelection(event, (Scrollable)treeViewer.getTree(), DebuggerView.this.getPreferences());
            }
        });
        SWTUtil.bindJFaceResourcesFontToControl((Control)treeViewer.getTree());
        this.updateColors();
        return treeViewer;
    }

    protected void fillContextMenu(IMenuManager menu) {
    }

    protected void updateColors() {
    }

    void updateSashOrientation(SashForm sash) {
        int orientation;
        Rectangle r = sash.getBounds();
        int n = orientation = (double)r.height * 1.25 >= (double)r.width ? 512 : 256;
        if (sash.getOrientation() != orientation) {
            sash.setOrientation(orientation);
        }
    }

    private void doPropertyChange(PropertyChangeEvent event) {
        this.updateColors();
        this.treeViewer.refresh(false);
    }

    private IPreferenceStore getPreferences() {
        return this.preferences;
    }

    private boolean isConnected() {
        IDebugTarget[] iDebugTargetArray = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int n = iDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget debugTarget = iDebugTargetArray[n2];
            if (!debugTarget.isTerminated()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void restoreSashWeights(IMemento memento) {
        String[] strs;
        if (memento != null && memento.getString(SASH_WEIGHTS) != null && (strs = memento.getString(SASH_WEIGHTS).split(",")).length == 2) {
            try {
                this.sashForm.setWeights(new int[]{Integer.parseInt(strs[0]), Integer.parseInt(strs[1])});
                return;
            }
            catch (NumberFormatException ex) {
                DartUtil.logError(ex);
            }
        }
        this.sashForm.setWeights(new int[]{40, 60});
    }

    private void updateConnectionStatus() {
        if (this.isConnected()) {
            this.setTitleImage(CONNECTED_IMAGE);
        } else {
            this.setTitleImage(NOT_CONNECTED_IMAGE);
        }
    }

    private void updateConnectionStatusAsync() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DebuggerView.this.updateConnectionStatus();
            }
        });
    }
}

