/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.view;

import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.utilities.ResourceUtil;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class DebuggerPatternMatchListener
implements IPatternMatchListener {
    public static String DARTIUM_PATTERN_1 = "\\((\\S+):(\\d+):(\\d+)\\)";
    public static String DARTIUM_PATTERN_2 = "\\((\\S+):(\\d+)\\)";
    public static String UNITTEST_PATTERN = "^  (\\S*\\.dart) (\\d*)";
    private static Pattern dartiumPattern1 = Pattern.compile(DARTIUM_PATTERN_1);
    private static Pattern dartiumPattern2 = Pattern.compile(DARTIUM_PATTERN_2);
    private static Pattern unitTestPattern = Pattern.compile(UNITTEST_PATTERN);
    private TextConsole console;

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    public int getCompilerFlags() {
        return 0;
    }

    public String getLineQualifier() {
        return null;
    }

    public String getPattern() {
        return "(\\(.*\\))|(  \\S*.dart .*)";
    }

    public void matchFound(PatternMatchEvent event) {
        if (this.console == null) {
            return;
        }
        try {
            Location location;
            String text = this.console.getDocument().get(event.getOffset(), event.getLength());
            Matcher match = dartiumPattern1.matcher(text);
            if (!(match.find() || (match = dartiumPattern2.matcher(text)).find() || (match = unitTestPattern.matcher(text)).find())) {
                match = null;
            }
            if (match != null && (location = this.parseForLocation(match.group(1), match.group(2))) != null && location.doesExist()) {
                this.console.addHyperlink((IHyperlink)new FileLink(location.getFile(), null, -1, -1, location.getLine()), event.getOffset() + match.start(1), match.end(2) - match.start(1));
                return;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected IResource getResource() {
        ProcessConsole processConsole;
        IProcess process;
        if (this.console instanceof ProcessConsole && (process = (processConsole = (ProcessConsole)this.console).getProcess()).getLaunch() != null) {
            SDBGLaunchConfigWrapper wrapper = new SDBGLaunchConfigWrapper(process.getLaunch().getLaunchConfiguration());
            return wrapper.getApplicationResource();
        }
        return null;
    }

    private IFile getIFileForAbsolutePath(String pathStr) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(pathStr));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Location parseForLocation(String url, String lineStr) {
        int line;
        try {
            line = Integer.parseInt(lineStr);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        try {
            String filePath;
            if (url == null) {
                return null;
            }
            if (url.startsWith("chrome-extension://") && (url = url.substring("chrome-extension://".length())).indexOf(47) != -1) {
                url = url.substring(url.indexOf(47) + 1);
            }
            if (url.startsWith("/")) {
                IFile file = this.getIFileForAbsolutePath(url);
                if (file == null) {
                    return null;
                }
                filePath = file.getFullPath().toPortableString();
            } else if (url.startsWith("file:")) {
                IFile file = this.getIFileForAbsolutePath(new URI(url).getPath());
                if (file == null) {
                    return null;
                }
                filePath = file.getFullPath().toPortableString();
            } else {
                filePath = url.indexOf(58) == -1 ? this.resolveRelativePath(url) : new URI(url).getPath();
            }
            if (filePath == null) {
                return null;
            }
            return new Location(filePath, line);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private String resolvePackageUri(String url) {
        IResource resource = this.getResource();
        if (resource != null) {
            Object file = null;
            if (file != null) {
                return file.getLocation().toFile().toURI().toString();
            }
            return null;
        }
        return null;
    }

    private String resolveRelativePath(String url) {
        IResource resource = this.getResource();
        if (resource != null) {
            IResource file = resource.getParent().findMember(url);
            if (file != null) {
                return file.getLocation().toPortableString();
            }
            return null;
        }
        return null;
    }

    private static class Location {
        private String filePath;
        private int line;

        public Location(String filePath, int line) {
            this.filePath = filePath;
            this.line = line;
        }

        public boolean doesExist() {
            return this.getFile() != null;
        }

        public IFile getFile() {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.filePath);
            if (resource instanceof IFile) {
                return (IFile)resource;
            }
            Path path = new Path(this.filePath);
            return ResourceUtil.getFile((File)path.toFile());
        }

        public int getLine() {
            return this.line;
        }

        public String toString() {
            return "[" + this.filePath + ":" + this.line + "]";
        }
    }
}

