/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.view;

import com.github.sdbg.debug.core.model.ISDBGVariable;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.util.ReflectionUtils;
import com.github.sdbg.debug.ui.internal.util.SWTUtil;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.variables.AvailableLogicalStructuresAction;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.details.AvailableDetailPanesAction;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneProxy;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DartVariablesView
extends VariablesView {
    private boolean visible;
    private TreeModelViewer treeViewer;
    private IPreferenceStore preferences;
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            DartVariablesView.this.doPropertyChange(event);
        }
    };

    public void becomesHidden() {
        this.visible = false;
        super.becomesHidden();
    }

    public void becomesVisible() {
        this.visible = true;
        super.becomesVisible();
    }

    public TreeModelViewer createViewer(Composite parent) {
        TreeModelViewer treeViewer;
        this.preferences = SDBGDebugUIPlugin.getDefault().getCombinedPreferenceStore();
        this.treeViewer = treeViewer = (TreeModelViewer)super.createViewer(parent);
        treeViewer.getTree().setBackgroundMode(2);
        treeViewer.getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                SWTUtil.eraseSelection(event, (Scrollable)treeViewer.getTree(), DartVariablesView.this.getPreferences());
            }
        });
        SWTUtil.bindJFaceResourcesFontToControl((Control)treeViewer.getTree());
        this.updateColors();
        return treeViewer;
    }

    public void dispose() {
        if (this.propertyChangeListener != null) {
            this.getPreferences().removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        super.dispose();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void refreshDetailPaneContents() {
        super.refreshDetailPaneContents();
        this.getDetailsText().setEditable(false);
    }

    public void setSelectionProvider(ISelectionProvider provider) {
    }

    public void viewerUpdatesComplete() {
        ISDBGVariable var;
        TreeItem item;
        Object data;
        super.viewerUpdatesComplete();
        TreeModelViewer viewer = (TreeModelViewer)this.getViewer();
        Tree tree = viewer.getTree();
        int itemCount = tree.getItemCount();
        if (itemCount > 0 && (data = (item = tree.getItem(0)).getData()) instanceof ISDBGVariable && (var = (ISDBGVariable)data).isThrownException()) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)var));
        }
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyVariableGroup"));
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add((IContributionItem)new Separator());
        AvailableLogicalStructuresAction action = new AvailableLogicalStructuresAction((VariablesView)this);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
        action = new AvailableDetailPanesAction((IDetailPaneContainer)this);
        if (this.isDetailPaneVisible() && action.isEnabled()) {
            menu.add((IAction)action);
        }
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("emptyNavigationGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected int[] getLastSashWeights() {
        return new int[]{12, 4};
    }

    protected void updateColors() {
        this.getPreferences();
        this.getDetailsText();
    }

    private void doPropertyChange(PropertyChangeEvent event) {
        this.updateColors();
        this.treeViewer.refresh(false);
    }

    private StyledText getDetailsText() {
        DetailPaneProxy detailProxy = (DetailPaneProxy)ReflectionUtils.getFieldObject((Object)this, "fDetailPane");
        StyledText text = (StyledText)ReflectionUtils.getFieldObject(detailProxy, "fCurrentControl");
        return text;
    }

    private IPreferenceStore getPreferences() {
        return this.preferences;
    }
}

