/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.view;

import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.util.ReflectionUtils;
import com.github.sdbg.debug.ui.internal.util.SWTUtil;
import com.github.sdbg.debug.ui.internal.view.RemoveAllBreakpointsAction;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.internal.ui.elements.adapters.DefaultBreakpointsViewInput;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneProxy;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.ui.IActionBars;

public class BreakpointsView
extends org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView {
    public static final String VIEW_ID = "com.google.dart.tools.debug.breakpointsView";
    private RemoveAllBreakpointsAction removeAllBreakpointsAction;
    ListViewer breakpointsViewer;
    private TreeModelViewer treeViewer;
    private IPreferenceStore preferences;
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            BreakpointsView.this.doPropertyChange(event);
        }
    };

    public Viewer createViewer(Composite parent) {
        Viewer viewer = super.createViewer(parent);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getMenuManager().removeAll();
        return viewer;
    }

    public void dispose() {
        if (this.removeAllBreakpointsAction != null) {
            this.removeAllBreakpointsAction.dispose();
        }
        if (this.propertyChangeListener != null) {
            this.getPreferences().removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.getPreferences().removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        super.dispose();
    }

    public void refreshDetailPaneContents() {
        super.refreshDetailPaneContents();
    }

    protected void configureToolBar(IToolBarManager manager) {
        this.removeAllBreakpointsAction = new RemoveAllBreakpointsAction();
        manager.add((IAction)this.removeAllBreakpointsAction);
        manager.update(true);
    }

    protected void contextActivated(ISelection selection) {
        IPresentationContext presentationContext = this.getTreeModelViewer().getPresentationContext();
        if (selection == null || selection.isEmpty()) {
            DefaultBreakpointsViewInput input = new DefaultBreakpointsViewInput(presentationContext);
            super.contextActivated((ISelection)new StructuredSelection((Object)input));
        } else if (selection instanceof TreeSelection) {
            if (((TreeSelection)selection).getFirstElement() instanceof DebugElement) {
                super.contextActivated((ISelection)new StructuredSelection((Object)new DefaultBreakpointsViewInput(presentationContext)));
            } else {
                super.contextActivated(selection);
            }
        } else {
            super.contextActivated(selection);
        }
        if (this.isAvailable() && this.isVisible()) {
            this.updateAction("ContentAssist");
        }
    }

    protected TreeModelViewer createTreeViewer(Composite parent) {
        TreeModelViewer treeViewer;
        this.preferences = SDBGDebugUIPlugin.getDefault().getCombinedPreferenceStore();
        this.treeViewer = treeViewer = super.createTreeViewer(parent);
        treeViewer.getTree().setBackgroundMode(2);
        treeViewer.getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                SWTUtil.eraseSelection(event, (Scrollable)treeViewer.getTree(), BreakpointsView.this.getPreferences());
            }
        });
        SWTUtil.bindJFaceResourcesFontToControl((Control)treeViewer.getTree());
        this.getPreferences().addPropertyChangeListener(this.propertyChangeListener);
        this.updateColors();
        return treeViewer;
    }

    protected void setViewerInput(Object context) {
        if (context != null && context instanceof DebugElement) {
            return;
        }
        super.setViewerInput(context);
    }

    protected void updateColors() {
    }

    private void doPropertyChange(PropertyChangeEvent event) {
        this.updateColors();
        this.treeViewer.refresh(false);
    }

    private Composite getDetails() {
        DetailPaneProxy detailProxy = (DetailPaneProxy)ReflectionUtils.getFieldObject((Object)this, "fDetailPane");
        Composite text = (Composite)ReflectionUtils.getFieldObject(detailProxy, "fCurrentControl");
        return text;
    }

    private IPreferenceStore getPreferences() {
        return this.preferences;
    }
}

