/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.util;

import com.github.sdbg.debug.ui.internal.util.ReflectionUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class SWTUtil {
    private static final int COMBO_VISIBLE_ITEM_COUNT = 30;
    private static Map<String, Font> fontCache = new HashMap<String, Font>();

    public static void bindJFaceResourcesFontToControl(final Control control) {
        SWTUtil.updateFontSizeFromJFaceResources(control);
        final FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                control.isDisposed();
            }
        };
        control.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                fontRegistry.removeListener(propertyListener);
            }
        });
        fontRegistry.addListener(propertyListener);
    }

    public static Font changeFontSize(Font oldFont, Font newFont) {
        if (newFont == null) {
            return oldFont;
        }
        FontData[] fontData = newFont.getFontData();
        return SWTUtil.changeFontSize(oldFont, fontData);
    }

    public static Font changeFontSize(Font oldFont, FontData[] sizedFontData) {
        if (sizedFontData == null || sizedFontData.length == 0) {
            return oldFont;
        }
        int height = sizedFontData[0].getHeight();
        return SWTUtil.changeFontSize(oldFont, height);
    }

    public static Font changeFontSize(Font oldFont, int height) {
        FontData[] data = oldFont.getFontData();
        FontData newData = new FontData(data[0].getName(), height, data[0].getStyle());
        return SWTUtil.getFont(oldFont.getDevice(), new FontData[]{newData});
    }

    public static FontData[] changeFontSize(FontData[] data, int height) {
        FontData newData = new FontData(data[0].getName(), height, data[0].getStyle());
        return new FontData[]{newData};
    }

    public static void eraseSelection(Event event, Scrollable control, IPreferenceStore prefs) {
        Color bgColor;
        event.detail &= 0xFFFFFFDF;
        if ((event.detail & 2) == 0) {
            return;
        }
        int clientWidth = control.getClientArea().width;
        GC gc = event.gc;
        Color oldFG = gc.getForeground();
        Color oldBG = gc.getBackground();
        Color fgColor = null;
        if (fgColor != null) {
            gc.setForeground(fgColor);
        }
        if ((bgColor = null) != null) {
            gc.setBackground(bgColor);
        }
        gc.fillRectangle(0, event.y, clientWidth, event.height);
        gc.setForeground(oldFG);
        gc.setBackground(oldBG);
        event.detail &= 0xFFFFFFFD;
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static Font getFont(Device device, FontData[] data) {
        String name = data[0].getName();
        int style = data[0].getStyle();
        int height = data[0].getHeight();
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(name).append(';');
        keyBuilder.append(height).append(';');
        keyBuilder.append(style);
        String key = keyBuilder.toString();
        Font font = fontCache.get(key);
        if (font == null || font.isDisposed()) {
            FontData newData = new FontData(name, height, style);
            font = new Font(device, newData);
            fontCache.put(key, font);
        }
        return font;
    }

    public static Shell getShell(Widget widget) {
        if (widget instanceof Control) {
            return ((Control)widget).getShell();
        }
        if (widget instanceof Caret) {
            return ((Caret)widget).getParent().getShell();
        }
        if (widget instanceof DragSource) {
            return ((DragSource)widget).getControl().getShell();
        }
        if (widget instanceof DropTarget) {
            return ((DropTarget)widget).getControl().getShell();
        }
        if (widget instanceof Menu) {
            return ((Menu)widget).getParent().getShell();
        }
        if (widget instanceof ScrollBar) {
            return ((ScrollBar)widget).getParent().getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static int getTableHeightHint(Table table, int rows) {
        if (table.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            table.setFont(JFaceResources.getDialogFont());
        }
        int result = table.getItemHeight() * rows + table.getHeaderHeight();
        if (table.getLinesVisible()) {
            result += table.getGridLineWidth() * (rows - 1);
        }
        return result;
    }

    public static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = SWTUtil.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    public static void setDefaultVisibleItemCount(Combo combo) {
        combo.setVisibleItemCount(30);
    }

    public static void setEnabledHierarchy(Control control, boolean enable) {
        Composite composite;
        Control[] children;
        if (control.getEnabled() != enable) {
            control.setEnabled(enable);
        }
        if (control instanceof Composite && (children = (composite = (Composite)control).getChildren()) != null) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                SWTUtil.setEnabledHierarchy(child, enable);
                ++n2;
            }
        }
    }

    public static void setItemHeightForFont(Control container) {
        GC gc = new GC((Drawable)container);
        try {
            try {
                Point size = gc.textExtent("A");
                ReflectionUtils.invokeMethod(container, "setItemHeight(int)", Math.max(16, size.y));
            }
            catch (Throwable throwable) {
                gc.dispose();
            }
        }
        finally {
            gc.dispose();
        }
    }

    private static void updateFontSizeFromJFaceResources(Control control) {
        Font newFont = JFaceResources.getFont((String)"org.eclipse.jface.viewerfont");
        Font oldFont = control.getFont();
        Font font = SWTUtil.changeFontSize(oldFont, newFont);
        control.setFont(font);
        if (control instanceof Table || control instanceof Tree) {
            SWTUtil.setItemHeightForFont(control);
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            if (children != null) {
                Control[] controlArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    SWTUtil.updateFontSizeFromJFaceResources(child);
                    ++n2;
                }
            }
            composite.layout();
        }
    }

    private SWTUtil() {
    }
}

