/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;

public class ReflectionUtils {
    public static String getClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return String.valueOf(ReflectionUtils.getClassName(clazz.getComponentType())) + "[]";
        }
        return clazz.getName();
    }

    public static Field getField(Object target, String name) {
        Assert.isNotNull((Object)target);
        Assert.isNotNull((Object)name);
        Class<?> targetClass = ReflectionUtils.getTargetClass(target);
        while (targetClass != null) {
            Field[] declaredFields;
            Field[] fieldArray = declaredFields = targetClass.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().equals(name)) {
                    field.setAccessible(true);
                    return field;
                }
                ++n2;
            }
            targetClass = targetClass.getSuperclass();
        }
        return null;
    }

    public static <T> T getFieldObject(Object target, String name) {
        Assert.isNotNull((Object)target);
        Assert.isNotNull((Object)name);
        Field field = ReflectionUtils.getField(target, name);
        if (field == null) {
            Class<?> targetClass = ReflectionUtils.getTargetClass(target);
            throw new IllegalArgumentException(String.valueOf(name) + " in " + targetClass);
        }
        try {
            return (T)field.get(target);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getMethod(Object target, String signature) {
        Assert.isNotNull((Object)target);
        Assert.isNotNull((Object)signature);
        Class<?> targetClass = ReflectionUtils.getTargetClass(target);
        while (targetClass != null) {
            Method[] methodArray = targetClass.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (ReflectionUtils.getMethodSignature(method).equals(signature)) {
                    method.setAccessible(true);
                    return method;
                }
                ++n2;
            }
            targetClass = targetClass.getSuperclass();
        }
        return null;
    }

    public static <T> T invokeMethod(Object target, String signature, Object ... args) {
        Assert.isNotNull((Object)target);
        Assert.isNotNull((Object)signature);
        Method method = ReflectionUtils.getMethod(target, signature);
        if (method == null) {
            Class<?> targetClass = ReflectionUtils.getTargetClass(target);
            throw new IllegalArgumentException(String.valueOf(signature) + " in " + targetClass);
        }
        try {
            return (T)method.invoke(target, args);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public static void setField(Object target, String name, Object value) {
        Assert.isNotNull((Object)target);
        Assert.isNotNull((Object)name);
        Field field = ReflectionUtils.getField(target, name);
        if (field == null) {
            Class<?> targetClass = ReflectionUtils.getTargetClass(target);
            throw new IllegalArgumentException(String.valueOf(name) + " in " + targetClass);
        }
        try {
            field.set(target, value);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static String getMethodSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName());
        sb.append('(');
        boolean firstParameter = true;
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> parameterType = classArray[n2];
            if (!firstParameter) {
                sb.append(',');
            }
            firstParameter = false;
            sb.append(ReflectionUtils.getClassName(parameterType));
            ++n2;
        }
        sb.append(')');
        return sb.toString();
    }

    private static Class<?> getTargetClass(Object target) {
        if (target instanceof Class) {
            return (Class)target;
        }
        return target.getClass();
    }
}

