/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.util;

import com.github.sdbg.core.DartCore;
import com.github.sdbg.debug.core.SDBGDebugCorePlugin;
import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.DartUtil;
import com.github.sdbg.debug.ui.internal.browser.BrowserLaunchShortcut;
import com.github.sdbg.debug.ui.internal.browser.Messages;
import com.github.sdbg.debug.ui.internal.chrome.ChromeLaunchShortcut;
import com.github.sdbg.debug.ui.internal.util.ILaunchShortcutExt;
import com.github.sdbg.utilities.ProcessRunner;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.ide.IDE;

public class LaunchUtils {
    public static final String LAUNCH_NAME = "Browser launch";
    private static List<ILaunchShortcut> shortcuts;

    public static boolean canFastLaunch(ILaunchConfiguration config) {
        SDBGLaunchConfigWrapper wrapper = new SDBGLaunchConfigWrapper(config);
        IProject project = wrapper.getProject();
        return project != null;
    }

    public static ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Select Dart Application");
        dialog.setMessage("&Select existing configuration:");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    public static ILaunchConfiguration chooseLatest(Collection<ILaunchConfiguration> launches) {
        long latestTime = 0L;
        ILaunchConfiguration latestLaunch = null;
        for (ILaunchConfiguration launch : launches) {
            SDBGLaunchConfigWrapper wrapper = new SDBGLaunchConfigWrapper(launch);
            long time = wrapper.getLastLaunchTime();
            if (time <= latestTime) continue;
            latestTime = time;
            latestLaunch = launch;
        }
        return latestLaunch;
    }

    public static void clearConsoles() {
        IConsole[] consoles;
        IConsole[] iConsoleArray = consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console instanceof ProcessConsole && console.getName().contains(LAUNCH_NAME)) {
                ((ProcessConsole)console).clearConsole();
            }
            ++n2;
        }
    }

    public static List<ILaunchConfiguration> getAllLaunches() {
        try {
            ILaunchConfiguration[] launchConfigs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            ArrayList<ILaunchConfiguration> validLaunchConfigs = new ArrayList<ILaunchConfiguration>();
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigs;
            int n = launchConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                IResource[] resources = config.getMappedResources();
                if (resources != null) {
                    int i = 0;
                    while (i < resources.length) {
                        IProject project = resources[i].getProject();
                        if (project != null && project.exists()) {
                            validLaunchConfigs.add(config);
                        }
                        ++i;
                    }
                } else {
                    validLaunchConfigs.add(config);
                }
                ++n2;
            }
            return validLaunchConfigs;
        }
        catch (CoreException exception) {
            DartUtil.logError(exception);
            return Collections.emptyList();
        }
    }

    public static ILaunchConfiguration[] getAllLaunchesArray() {
        List<ILaunchConfiguration> configs = LaunchUtils.getAllLaunches();
        return configs.toArray(new ILaunchConfiguration[configs.size()]);
    }

    public static List<ILaunchShortcut> getAllLaunchShortcuts() {
        if (shortcuts == null) {
            shortcuts = new ArrayList<ILaunchShortcut>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.debug.ui", "launchShortcuts");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            try {
                IConfigurationElement[] iConfigurationElementArray = infos;
                int n = infos.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    ILaunchShortcut shortcut = (ILaunchShortcut)element.createExecutableExtension("class");
                    shortcuts.add(shortcut);
                    ++n2;
                }
            }
            catch (CoreException ce) {
                DartUtil.logError(ce);
            }
        }
        return shortcuts;
    }

    public static List<ILaunchShortcut> getApplicableLaunchShortcuts(IResource resource) {
        ArrayList<ILaunchShortcut> candidates = new ArrayList<ILaunchShortcut>();
        for (ILaunchShortcut shortcut : LaunchUtils.getAllLaunchShortcuts()) {
            ILaunchShortcutExt handler;
            if (!(shortcut instanceof ILaunchShortcutExt) || !(handler = (ILaunchShortcutExt)shortcut).canLaunch(resource)) continue;
            candidates.add(shortcut);
        }
        return candidates;
    }

    public static ILaunchShortcut getBrowserLaunchShortcut() {
        for (ILaunchShortcut shortcut : LaunchUtils.getAllLaunchShortcuts()) {
            if (!(shortcut instanceof BrowserLaunchShortcut)) continue;
            return shortcut;
        }
        return null;
    }

    public static ILaunchShortcut getChromeLaunchShortcut() {
        for (ILaunchShortcut shortcut : LaunchUtils.getAllLaunchShortcuts()) {
            if (!(shortcut instanceof ChromeLaunchShortcut)) continue;
            return shortcut;
        }
        return null;
    }

    public static List<ILaunchConfiguration> getExistingLaunchesFor(IResource resource) {
        LinkedHashSet<ILaunchConfiguration> configs = new LinkedHashSet<ILaunchConfiguration>();
        for (ILaunchShortcut shortcut : LaunchUtils.getAllLaunchShortcuts()) {
            if (!(shortcut instanceof ILaunchShortcutExt)) continue;
            ILaunchShortcutExt handler = (ILaunchShortcutExt)shortcut;
            configs.addAll(Arrays.asList(handler.getAssociatedLaunchConfigurations(resource)));
        }
        return new ArrayList<ILaunchConfiguration>(configs);
    }

    public static List<ILaunchConfiguration> getLaunchesFor(IProject project) {
        ArrayList<ILaunchConfiguration> launches = new ArrayList<ILaunchConfiguration>();
        for (ILaunchConfiguration config : LaunchUtils.getAllLaunches()) {
            try {
                if (config.getMappedResources() == null) continue;
                IResource[] iResourceArray = config.getMappedResources();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (project.equals((Object)resource.getProject()) && !launches.contains(config)) {
                        launches.add(config);
                    }
                    ++n2;
                }
            }
            catch (CoreException exception) {
                DartUtil.logError(exception);
            }
        }
        return launches;
    }

    public static ILaunchConfiguration getLaunchFor(IResource resource) throws CoreException {
        ILaunchConfiguration config;
        if (resource instanceof IProject && (config = LaunchUtils.getLaunchForProject((IProject)resource)) != null) {
            return config;
        }
        List<ILaunchConfiguration> configs = LaunchUtils.getExistingLaunchesFor(resource);
        if (configs.size() > 0) {
            return LaunchUtils.chooseLatest(configs);
        }
        return null;
    }

    public static ILaunchConfiguration getLaunchForProject(IProject project) {
        List<ILaunchConfiguration> launches = LaunchUtils.getLaunchesFor(project);
        if (launches.size() > 0) {
            return LaunchUtils.chooseLatest(launches);
        }
        return null;
    }

    public static String getLongLaunchName(ILaunchConfiguration config) {
        SDBGLaunchConfigWrapper wrapper = new SDBGLaunchConfigWrapper(config);
        if (wrapper.getProject() != null) {
            return String.valueOf(config.getName()) + " from " + wrapper.getProject().getName();
        }
        return config.getName();
    }

    public static IResource getSelectedResource(IWorkbenchWindow window) {
        IStructuredSelection ss;
        ISelection selection;
        ISelectionProvider provider;
        IWorkbenchPartSite site;
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part instanceof IEditorPart) {
            IEditorPart epart = (IEditorPart)part;
            return (IResource)epart.getEditorInput().getAdapter(IResource.class);
        }
        if (part != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            for (Object next : ss) {
                IResource resource;
                if (next instanceof IResource) {
                    return (IResource)next;
                }
                if (next == null || (resource = (IResource)Platform.getAdapterManager().getAdapter(next, IResource.class)) == null) continue;
                return resource;
            }
        }
        if (page.getActiveEditor() != null) {
            return (IResource)page.getActiveEditor().getEditorInput().getAdapter(IResource.class);
        }
        return null;
    }

    public static void launch(ILaunchConfiguration config, String mode) {
        SDBGLaunchConfigWrapper wrapper = new SDBGLaunchConfigWrapper(config);
        IProject project = wrapper.getProject();
        if (project != null) {
            IDE.saveAllEditors((IResource[])new IResource[]{project}, (boolean)false);
        }
        if (!LaunchUtils.canFastLaunch(config)) {
            try {
                IJobManager jobManager = Job.getJobManager();
                jobManager.join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
                jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException e) {
                SDBGDebugCorePlugin.logError((Throwable)e);
            }
        }
        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
    }

    public static void launchInExternalBrowser(String url) throws CoreException {
        String browserName = SDBGDebugCorePlugin.getPlugin().getBrowserName();
        if (browserName.length() == 0) {
            throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.ui", "Specify browser to launch in Preferences > Run and Debug"));
        }
        ArrayList<String> cmd = new ArrayList<String>();
        if (DartCore.isMac()) {
            cmd.add("/usr/bin/open");
            cmd.add("-a");
        }
        cmd.add(browserName);
        cmd.add(url);
        if (SDBGDebugCorePlugin.getPlugin().getBrowserArgs().length() != 0) {
            if (DartCore.isMac()) {
                cmd.add("--args");
                cmd.add(SDBGDebugCorePlugin.getPlugin().getBrowserArgs());
            } else {
                cmd.addAll(Arrays.asList(SDBGDebugCorePlugin.getPlugin().getBrowserArgsAsArray()));
            }
        }
        try {
            ProcessBuilder builder = new ProcessBuilder(cmd);
            ProcessRunner runner = new ProcessRunner(builder);
            runner.runAsync();
            runner.await((IProgressMonitor)new NullProgressMonitor(), 500);
            if (runner.getExitCode() != 0) {
                if (DartCore.isWindows() && browserName.toLowerCase().indexOf("firefox") != -1 && runner.getExitCode() == 1) {
                    return;
                }
                throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.ui", "Could not launch browser \"" + browserName + "\" : \n\n" + runner.getStdErr()));
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.core", Messages.BrowserLaunchConfigurationDelegate_BrowserNotFound, (Throwable)e));
        }
    }

    public static void openBrowser(String url) throws CoreException {
        IWebBrowser browser = null;
        try {
            browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(128, "defaultBrowser", "Default Browser", "Browser");
            if (browser == null) {
                throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.core", Messages.BrowserLaunchConfigurationDelegate_DefaultBrowserNotFound));
            }
            final IWebBrowser defaultBrowser = browser;
            final URL urlToOpen = new URL(url);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        defaultBrowser.openURL(urlToOpen);
                    }
                    catch (PartInitException e) {
                        SDBGDebugCorePlugin.logError((String)Messages.BrowserLaunchConfigurationDelegate_DefaultBrowserNotFound, (Throwable)e);
                    }
                }
            });
        }
        catch (MalformedURLException malformedURLException) {
            throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.core", Messages.BrowserLaunchConfigurationDelegate_UrlError));
        }
    }

    private LaunchUtils() {
    }
}

