/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.util;

import com.github.sdbg.debug.ui.internal.chrome.ChromeLaunchMessages;
import com.github.sdbg.debug.ui.internal.util.AppSelectionDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class LaunchTargetComposite
extends Composite {
    protected ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LaunchTargetComposite.this.notifyPanelChanged();
        }
    };
    private Button htmlButton;
    private Text htmlText;
    private Button htmlBrowseButton;
    private Label urlLabel;
    private Button urlButton;
    private Text urlText;
    private Button urlLaunchTabCheck;
    private Text projectText;
    private Button projectBrowseButton;
    private int widthHint;
    private Label projectLabel;

    public LaunchTargetComposite(Composite parent, int style) {
        this(parent, style, false, false, false);
    }

    public LaunchTargetComposite(Composite parent, int style, boolean allowHtmlFile, boolean urlIsFilter, boolean launchTabInUrl) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)this);
        Group group = new Group((Composite)this, 0);
        group.setText(ChromeLaunchMessages.ChromeMainTab_LaunchTarget);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)group);
        if (allowHtmlFile) {
            this.createHtmlField((Composite)group);
        }
        Label filler = new Label((Composite)group, 0);
        GridDataFactory.swtDefaults().span(3, 1).hint(-1, 4).applyTo((Control)filler);
        this.createUrlField((Composite)group, allowHtmlFile, urlIsFilter, launchTabInUrl);
    }

    public int getButtonWidthHint() {
        return this.widthHint;
    }

    public String getErrorMessage() {
        if (this.htmlButton != null && this.htmlButton.getSelection() && this.htmlText.getText().length() == 0) {
            return ChromeLaunchMessages.ChromeMainTab_NoHtmlFile;
        }
        if (this.urlButton == null || this.urlButton.getSelection()) {
            String url = this.urlText.getText();
            if (this.urlButton != null || this.urlLaunchTabCheck != null && this.urlLaunchTabCheck.getSelection()) {
                if (url.length() == 0) {
                    return ChromeLaunchMessages.ChromeMainTab_NoUrl;
                }
                if (!this.isValidUrl(url)) {
                    return ChromeLaunchMessages.ChromeMainTab_InvalidURL;
                }
            }
            if (this.projectText.getText().length() == 0) {
                return ChromeLaunchMessages.ChromeMainTab_NoProject;
            }
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectText.getText());
                if (!project.exists()) {
                    return ChromeLaunchMessages.ChromeMainTab_InvalidProject;
                }
            }
            catch (IllegalArgumentException e) {
                return String.valueOf(ChromeLaunchMessages.ChromeMainTab_InvalidProject) + ": " + e.getMessage();
            }
        }
        return null;
    }

    public boolean getHtmlButtonSelection() {
        return this.htmlButton != null ? this.htmlButton.getSelection() : false;
    }

    public String getHtmlFileName() {
        return this.htmlText != null ? this.htmlText.getText().trim() : "";
    }

    public int getLabelColumnWidth() {
        this.projectLabel.pack();
        return this.projectLabel.getSize().x;
    }

    public String getProject() {
        return this.projectText.getText().trim();
    }

    public String getUrlString() {
        return this.urlText.getText().trim();
    }

    public boolean isLaunchTabWithUrl() {
        return this.urlLaunchTabCheck != null && this.urlLaunchTabCheck.getSelection();
    }

    public void setHtmlButtonSelection(boolean state) {
        if (this.htmlButton != null) {
            this.htmlButton.setSelection(state);
            this.urlButton.setSelection(!state);
            this.updateEnablements(state);
        }
    }

    public void setHtmlTextValue(String string) {
        if (this.htmlText != null) {
            this.htmlText.setText(string);
        }
    }

    public void setLaunchTabWithUrl(boolean value) {
        if (this.urlLaunchTabCheck != null) {
            this.urlLaunchTabCheck.setSelection(value);
            this.updateUrlLabel();
        }
    }

    public void setProjectTextValue(String sourceDirectoryName) {
        this.projectText.setText(sourceDirectoryName);
    }

    public void setUrlTextValue(String string) {
        this.urlText.setText(string);
    }

    protected void createHtmlField(Composite composite) {
        this.htmlButton = new Button(composite, 16);
        this.htmlButton.setText(ChromeLaunchMessages.ChromeMainTab_HtmlFileLabel);
        this.htmlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchTargetComposite.this.updateEnablements(true);
                LaunchTargetComposite.this.notifyPanelChanged();
            }
        });
        this.htmlText = new Text(composite, 2052);
        this.htmlText.addModifyListener(this.textModifyListener);
        GridDataFactory.swtDefaults().align(4, 0x1000000).hint(400, -1).grab(true, false).applyTo((Control)this.htmlText);
        this.htmlBrowseButton = new Button(composite, 8);
        this.htmlBrowseButton.setText(ChromeLaunchMessages.ChromeMainTab_SelectHtmlFile);
        PixelConverter converter = new PixelConverter((Control)this.htmlBrowseButton);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        GridDataFactory.swtDefaults().align(4, 1).hint(widthHint, -1).applyTo((Control)this.htmlBrowseButton);
        this.htmlBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchTargetComposite.this.handleApplicationBrowseButton();
            }
        });
    }

    protected void createUrlField(Composite composite, boolean allowHtmlFile, boolean urlIsFilter, boolean launchTabInUrl) {
        if (allowHtmlFile) {
            this.urlButton = new Button(composite, 16);
            this.urlButton.setText(urlIsFilter ? ChromeLaunchMessages.ChromeMainTab_UrlFilterLabel : ChromeLaunchMessages.ChromeMainTab_UrlLabel);
            this.urlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LaunchTargetComposite.this.updateEnablements(false);
                    LaunchTargetComposite.this.notifyPanelChanged();
                }
            });
        } else {
            this.urlLabel = new Label(composite, 0);
            this.urlLabel.setText(urlIsFilter ? ChromeLaunchMessages.ChromeMainTab_UrlFilterLabel : ChromeLaunchMessages.ChromeMainTab_UrlLabel);
            GridDataFactory.swtDefaults().hint(80, -1).applyTo((Control)this.urlLabel);
        }
        this.urlText = new Text(composite, 2052);
        this.urlText.addModifyListener(this.textModifyListener);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.urlText);
        new Label(composite, 0);
        if (launchTabInUrl) {
            new Label(composite, 0);
            this.urlLaunchTabCheck = new Button(composite, 32);
            this.urlLaunchTabCheck.setText("Launch a new browser tab with this URL if there is none opened");
            GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.urlLaunchTabCheck);
            this.urlLaunchTabCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LaunchTargetComposite.this.updateUrlLabel();
                    LaunchTargetComposite.this.notifyPanelChanged();
                }
            });
            Label label = new Label(composite, 0);
            GridDataFactory.swtDefaults().span(3, 1).hint(-1, 5).applyTo((Control)label);
        }
        this.projectLabel = new Label(composite, 0);
        this.projectLabel.setText(ChromeLaunchMessages.ChromeMainTab_ProjectLabel);
        if (allowHtmlFile) {
            GridDataFactory.swtDefaults().indent(20, 0).applyTo((Control)this.projectLabel);
        } else {
            GridDataFactory.swtDefaults().applyTo((Control)this.projectLabel);
        }
        this.projectText = new Text(composite, 2052);
        this.projectText.addModifyListener(this.textModifyListener);
        this.projectText.setCursor(composite.getShell().getDisplay().getSystemCursor(0));
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.projectText);
        this.projectBrowseButton = new Button(composite, 8);
        this.projectBrowseButton.setText(ChromeLaunchMessages.ChromeMainTab_SelectProject);
        PixelConverter converter = new PixelConverter((Control)this.projectBrowseButton);
        this.widthHint = converter.convertHorizontalDLUsToPixels(61);
        GridDataFactory.swtDefaults().align(4, 1).hint(this.widthHint, -1).applyTo((Control)this.projectBrowseButton);
        this.projectBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchTargetComposite.this.handleProjectBrowseButton();
            }
        });
        this.updateUrlLabel();
    }

    protected void handleApplicationBrowseButton() {
        IFile file;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        AppSelectionDialog dialog = new AppSelectionDialog(this.getShell(), (IContainer)workspace.getRoot(), new AppSelectionDialog.HtmlResourceFilter());
        dialog.setTitle(ChromeLaunchMessages.ChromeMainTab_SelectHtml);
        dialog.setInitialPattern(".", 2);
        Path path = new Path(this.htmlText.getText());
        if (workspace.validatePath(path.toString(), 1).isOK() && (file = workspace.getRoot().getFile((IPath)path)) != null && file.exists()) {
            dialog.setInitialSelections(new Object[]{path});
        }
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IFile) {
            IFile file2 = (IFile)results[0];
            String pathStr = file2.getFullPath().toPortableString();
            this.htmlText.setText(pathStr);
            this.notifyPanelChanged();
        }
    }

    protected void handleProjectBrowseButton() {
        IProject project = this.chooseProject();
        if (project != null) {
            this.projectText.setText(project.getName());
            this.notifyPanelChanged();
        }
    }

    protected void updateEnablements(boolean isFile) {
        if (isFile) {
            this.htmlText.setEnabled(true);
            this.htmlBrowseButton.setEnabled(true);
            this.urlText.setEnabled(false);
            this.projectText.setEnabled(false);
            this.projectBrowseButton.setEnabled(false);
        } else {
            this.htmlText.setEnabled(false);
            this.htmlBrowseButton.setEnabled(false);
            this.urlText.setEnabled(true);
            this.projectText.setEnabled(true);
            this.projectBrowseButton.setEnabled(true);
        }
    }

    protected void updateUrlLabel() {
        if (this.urlLaunchTabCheck != null) {
            if (this.urlButton != null) {
                this.urlButton.setText(this.urlLaunchTabCheck.getSelection() ? ChromeLaunchMessages.ChromeMainTab_UrlLabel : ChromeLaunchMessages.ChromeMainTab_UrlFilterLabel);
            } else {
                this.urlLabel.setText(this.urlLaunchTabCheck.getSelection() ? ChromeLaunchMessages.ChromeMainTab_UrlLabel : ChromeLaunchMessages.ChromeMainTab_UrlFilterLabel);
            }
        }
    }

    private IProject chooseProject() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IProject)element).getName();
            }
        });
        dialog.setTitle(ChromeLaunchMessages.ChromeMainTab_SelectProjectTitle);
        dialog.setMessage(ChromeLaunchMessages.ChromeMainTab_SelectProjectMessage);
        dialog.setElements((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects());
        IProject project = null;
        try {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProject());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (project != null && project.exists()) {
            dialog.setInitialSelections(new Object[]{project});
        }
        if (dialog.open() == 0) {
            return (IProject)dialog.getFirstResult();
        }
        return null;
    }

    private boolean isValidUrl(String url) {
        String[] validSchemes;
        String[] stringArray = validSchemes = new String[]{"file:", "http:", "https:"};
        int n = validSchemes.length;
        int n2 = 0;
        while (n2 < n) {
            String scheme = stringArray[n2];
            if (url.startsWith(scheme)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void notifyPanelChanged() {
        Event event = new Event();
        event.type = 24;
        event.widget = this;
        this.notifyListeners(24, event);
    }
}

