/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.util;

import com.github.sdbg.debug.ui.internal.chromeapp.ChromeAppLaunchShortcut;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class DartPropertyTester
extends PropertyTester {
    private static <T> T getAdapter(Object adaptable, Class<? extends T> adapterType) {
        if (adapterType.isInstance(adaptable)) {
            return (T)adaptable;
        }
        IAdapterManager adapterManager = Platform.getAdapterManager();
        assert (adapterManager != null);
        return (T)adapterManager.getAdapter(adaptable, adapterType);
    }

    private static IResource getResource(IPath path) {
        IResource res = null;
        if (path != null) {
            IContainer[] containers;
            IFile[] files;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (path.getDevice() == null) {
                res = root.findMember(path);
            }
            if (res == null && (files = root.findFilesForLocationURI(URIUtil.toURI((IPath)path.makeAbsolute()))).length > 0 && files[0].isAccessible()) {
                res = files[0];
            }
            if (res == null && (containers = root.findContainersForLocationURI(URIUtil.toURI((IPath)path.makeAbsolute()))).length > 0) {
                res = containers[0];
            }
        }
        return res;
    }

    private static IResource resolveTargetResource(IResource resource) {
        if (!resource.isLinked()) {
            return resource;
        }
        IResource resolvedResource = DartPropertyTester.getResource(resource.getLocation());
        return resolvedResource != null ? resolvedResource : resource;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IResource resource = DartPropertyTester.getAdapter(receiver, IResource.class);
        if (resource == null) {
            return false;
        }
        resource = DartPropertyTester.resolveTargetResource(resource);
        if (property.equals("isDartProject")) {
            return this.isDartProject(resource);
        }
        if (property.equals("isInDartProject")) {
            return this.isInDartProject(resource);
        }
        return false;
    }

    protected boolean containsChromeApp(IResource resource) {
        if (resource instanceof IFile) {
            if (ChromeAppLaunchShortcut.isManifestFile(resource)) {
                return true;
            }
            return ChromeAppLaunchShortcut.containsManifestJsonFile(resource.getParent());
        }
        if (resource instanceof IContainer) {
            return ChromeAppLaunchShortcut.containsManifestJsonFile((IContainer)resource);
        }
        return false;
    }

    protected boolean isDartProject(IResource resource) {
        return false;
    }

    protected boolean isInDartProject(IResource resource) {
        return false;
    }
}

