/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.util;

import com.github.sdbg.core.DartCore;
import com.github.sdbg.debug.ui.internal.util.IResourceFilter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class AppSelectionDialog
extends FilteredResourcesSelectionDialog {
    private IResourceFilter filter;

    public AppSelectionDialog(Shell shell, IContainer container, IResourceFilter filter) {
        super(shell, false, container, 1);
        this.filter = filter;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        final FilteredItemsSelectionDialog.ItemsFilter delegateFilter = super.createFilter();
        return new FilteredResourcesSelectionDialog.ResourceFilter(this){

            public boolean isConsistentItem(Object item) {
                return delegateFilter.isConsistentItem(item);
            }

            public boolean matchItem(Object item) {
                if (!(item instanceof IResource)) {
                    return false;
                }
                IResource resource = (IResource)item;
                if (!delegateFilter.matchItem((Object)resource)) {
                    return false;
                }
                return AppSelectionDialog.this.filter.matches(resource);
            }
        };
    }

    public static class HtmlResourceFilter
    implements IResourceFilter {
        @Override
        public boolean matches(IResource resource) {
            return DartCore.isHtmlLikeFileName((String)resource.getName());
        }
    }

    public static class HtmlWebResourceFilter
    implements IResourceFilter {
        @Override
        public boolean matches(IResource resource) {
            return DartCore.isHtmlLikeFileName((String)resource.getName()) && resource.getParent().getName().equals("web");
        }
    }
}

