/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.util;

import com.github.sdbg.core.DartCore;
import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.DartUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class AbstractLaunchShortcut
implements ILaunchShortcut2 {
    private String launchTypeLabel;

    public AbstractLaunchShortcut(String launchTypeLabel) {
        this.launchTypeLabel = launchTypeLabel;
    }

    public ILaunchConfiguration[] getAssociatedLaunchConfigurations(IResource resource) {
        ArrayList<ILaunchConfiguration> results = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.getConfigurationType());
            if (resource != null) {
                int i = 0;
                while (i < configs.length) {
                    ILaunchConfiguration config = configs[i];
                    if (this.testSimilar(resource, config)) {
                        results.add(config);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            DartUtil.logError(e);
        }
        return results.toArray(new ILaunchConfiguration[results.size()]);
    }

    public final IResource getLaunchableResource(IEditorPart editor) {
        IResource resource = (IResource)editor.getEditorInput().getAdapter(IResource.class);
        if (resource != null) {
            return this.getLaunchableResource(resource);
        }
        return null;
    }

    public final IResource getLaunchableResource(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        Object resource = obj instanceof IResource ? (IResource)obj : (obj instanceof IAdaptable ? (IResource)((IAdaptable)obj).getAdapter(IResource.class) : null);
        return this.getLaunchableResource(resource);
    }

    public final ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return null;
    }

    public final ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return null;
    }

    public final void launch(IEditorPart editor, String mode) {
        IResource resource = (IResource)editor.getEditorInput().getAdapter(IResource.class);
        if (resource != null && (resource = this.getLaunchableResource(resource)) != null) {
            this.launch(resource, mode);
            return;
        }
        MessageDialog.openWarning(null, (String)("Error Launching " + this.launchTypeLabel), (String)"Unable to locate launchable resource.");
    }

    public final void launch(ISelection selection, String mode) {
        IResource resource = this.getLaunchableResource(selection);
        if (resource != null) {
            this.launch(resource, mode);
            return;
        }
        MessageDialog.openWarning(null, (String)("Error Launching " + this.launchTypeLabel), (String)"Unable to locate associated html file");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Select Dart Application");
        dialog.setMessage("&Select existing configuration:");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected final ILaunchConfiguration findConfig(IResource resource) throws OperationCanceledException {
        List<ILaunchConfiguration> candidateConfigs = Arrays.asList(this.getAssociatedLaunchConfigurations(resource));
        int candidateCount = candidateConfigs.size();
        if (candidateCount == 1) {
            return candidateConfigs.get(0);
        }
        if (candidateCount > 1) {
            ILaunchConfiguration result = this.chooseConfiguration(candidateConfigs);
            if (result != null) {
                return result;
            }
            throw new OperationCanceledException();
        }
        return null;
    }

    protected abstract ILaunchConfigurationType getConfigurationType();

    protected IResource getLaunchableResource(Object originalResource) {
        if (originalResource == null) {
            return null;
        }
        if (originalResource instanceof IResource) {
            IResource resource = (IResource)originalResource;
            if (!resource.isAccessible()) {
                return null;
            }
            return this.getPrimaryLaunchTarget(resource);
        }
        return null;
    }

    protected boolean isBrowserApplication(IResource resource) {
        return this.getPrimaryLaunchTarget(resource) != null;
    }

    protected abstract void launch(IResource var1, String var2);

    protected boolean testSimilar(IResource resource, ILaunchConfiguration config) {
        SDBGLaunchConfigWrapper launchWrapper = new SDBGLaunchConfigWrapper(config);
        IResource appResource = launchWrapper.getApplicationResource();
        return appResource == resource || appResource != null && appResource.equals((Object)resource);
    }

    private IResource getPrimaryLaunchTarget(IResource resource) {
        if (DartCore.isHtmlLikeFileName((String)resource.getName())) {
            return resource;
        }
        return null;
    }
}

