/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.pubserve;

import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.util.AppSelectionDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class PubServeMainTab
extends AbstractLaunchConfigurationTab {
    private static Font italicFont;
    private Text argumentText;
    private Text htmlText;
    private Button htmlBrowseButton;

    private static Font getItalicFont(Font font) {
        if (italicFont == null) {
            FontData data = font.getFontData()[0];
            italicFont = new Font((Device)Display.getDefault(), new FontData(data.getName(), data.getHeight(), 2));
        }
        return italicFont;
    }

    public PubServeMainTab() {
        this.setMessage("Create a configuration to launch a Dart application in Dartium, use pub to serve contents");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().spacing(1, 3).applyTo(composite);
        Group group = new Group(composite, 0);
        group.setText("Launch target");
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)group);
        Label label = new Label((Composite)group, 0);
        label.setText("HTML file:");
        this.htmlText = new Text((Composite)group, 2052);
        this.htmlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PubServeMainTab.this.notifyPanelChanged();
            }
        });
        GridDataFactory.swtDefaults().align(4, 0x1000000).hint(400, -1).grab(true, false).applyTo((Control)this.htmlText);
        this.htmlBrowseButton = new Button((Composite)group, 8);
        this.htmlBrowseButton.setText("Select...");
        PixelConverter converter = new PixelConverter((Control)this.htmlBrowseButton);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        GridDataFactory.swtDefaults().align(4, 1).hint(widthHint, -1).applyTo((Control)this.htmlBrowseButton);
        this.htmlBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PubServeMainTab.this.handleApplicationBrowseButton();
            }
        });
        group = new Group(composite, 0);
        group.setText("Dartium settings");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)group);
        ((GridLayout)group.getLayout()).marginBottom = 5;
        Label argsLabel = new Label((Composite)group, 0);
        argsLabel.setText("Browser arguments:");
        this.argumentText = new Text((Composite)group, 2052);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.argumentText);
        Label messageLabel = new Label(composite, 0);
        messageLabel.setText("Note: Does not support debugging of applications in Dartium");
        messageLabel.setFont(PubServeMainTab.getItalicFont(label.getFont()));
        this.setControl((Control)composite);
    }

    public void dispose() {
        Control control = this.getControl();
        if (control != null) {
            control.dispose();
            this.setControl(null);
        }
    }

    public String getName() {
        return "Main";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        SDBGLaunchConfigWrapper dartLauncher = new SDBGLaunchConfigWrapper(configuration);
        this.htmlText.setText(dartLauncher.appendQueryParams(dartLauncher.getApplicationName()));
        this.argumentText.setText(dartLauncher.getArguments());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        SDBGLaunchConfigWrapper dartLauncher = new SDBGLaunchConfigWrapper((ILaunchConfiguration)configuration);
        dartLauncher.setShouldLaunchFile(true);
        String fileUrl = this.htmlText.getText().trim();
        if (fileUrl.indexOf(63) == -1) {
            dartLauncher.setApplicationName(fileUrl);
            dartLauncher.setUrlQueryParams("");
        } else {
            int index = fileUrl.indexOf(63);
            dartLauncher.setApplicationName(fileUrl.substring(0, index));
            dartLauncher.setUrlQueryParams(fileUrl.substring(index + 1));
        }
        dartLauncher.setArguments(this.argumentText.getText().trim());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        SDBGLaunchConfigWrapper dartLauncher = new SDBGLaunchConfigWrapper((ILaunchConfiguration)configuration);
        dartLauncher.setShouldLaunchFile(true);
        dartLauncher.setApplicationName("");
    }

    protected void handleApplicationBrowseButton() {
        IFile file;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        AppSelectionDialog dialog = new AppSelectionDialog(this.getShell(), (IContainer)workspace.getRoot(), new AppSelectionDialog.HtmlWebResourceFilter());
        dialog.setTitle("Select a HTML page to launch");
        dialog.setInitialPattern(".", 2);
        Path path = new Path(this.htmlText.getText());
        if (workspace.validatePath(path.toString(), 1).isOK() && (file = workspace.getRoot().getFile((IPath)path)) != null && file.exists()) {
            dialog.setInitialSelections(new Object[]{path});
        }
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IFile) {
            IFile file2 = (IFile)results[0];
            String pathStr = file2.getFullPath().toPortableString();
            this.htmlText.setText(pathStr);
        }
    }

    private void notifyPanelChanged() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }
}

