/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.presentation;

import com.github.sdbg.debug.core.SDBGDebugCorePlugin;
import com.github.sdbg.debug.core.breakpoints.SDBGBreakpoint;
import com.github.sdbg.debug.core.model.IExceptionStackFrame;
import com.github.sdbg.debug.core.model.ISDBGLogicalStructureTypeExtensions;
import com.github.sdbg.debug.core.model.ISDBGStackFrame;
import com.github.sdbg.debug.core.model.ISDBGValue;
import com.github.sdbg.debug.core.model.ISDBGVariable;
import com.github.sdbg.debug.core.util.SDBGNoSourceFoundElement;
import com.github.sdbg.debug.ui.internal.DartUtil;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.presentation.LogicalValueProvider;
import com.github.sdbg.debug.ui.internal.presentation.SDBGSourceNotFoundEditorInput;
import com.github.sdbg.debug.ui.internal.util.DebuggerEditorInput;
import com.github.sdbg.debug.ui.internal.util.StorageEditorInput;
import com.github.sdbg.utilities.Streams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IInstructionPointerPresentation;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class SDBGDebugModelPresentation
implements IDebugModelPresentation,
IInstructionPointerPresentation {
    private static final String BREAK_ON_EXCEPTION_ANNOTAION = "org.eclipse.debug.ui.currentIPEx";
    private static final LogicalValueProvider LOGICAL_VALUE_PROVIDER = new LogicalValueProvider();
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();
    private Collection<ISourcePresentation> sourcePresentations;

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void computeDetail(final IValue value, final IValueDetailListener listener) {
        if (value instanceof ISDBGValue) {
            ISDBGValue debugValue = (ISDBGValue)value;
            debugValue.computeDetail(new ISDBGValue.IValueCallback(){

                public void detailComputed(String stringValue) {
                    listener.detailComputed(value, stringValue);
                }
            });
        } else {
            listener.detailComputed(value, null);
        }
    }

    public void dispose() {
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (input instanceof SDBGSourceNotFoundEditorInput) {
            return "com.github.sdbg.debug.ui.internal.presentation.SDBGSourceNotFoundEditor";
        }
        for (ISourcePresentation sourcePresentation : this.getSourcePresentations()) {
            String editorId = sourcePresentation.getEditorId(input, element);
            if (editorId == null) continue;
            return editorId;
        }
        try {
            return IDE.getEditorDescriptor((String)input.getName()).getId();
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public IEditorInput getEditorInput(Object element) {
        for (ISourcePresentation sourcePresentation : this.getSourcePresentations()) {
            IEditorInput result = sourcePresentation.getEditorInput(element);
            if (result == null) continue;
            return result;
        }
        if (element instanceof IMarker) {
            element = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint((IMarker)element);
        }
        if (element instanceof SDBGBreakpoint) {
            IFile file = ((SDBGBreakpoint)element).getFile();
            if (file != null) {
                return new FileEditorInput(file);
            }
            return new FileStoreEditorInput(EFS.getLocalFileSystem().getStore((IPath)new Path(((SDBGBreakpoint)element).getFilePath())));
        }
        if (element instanceof ILineBreakpoint) {
            return new FileEditorInput((IFile)((ILineBreakpoint)element).getMarker().getResource());
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof LocalFileStorage) {
            try {
                URI fileUri = ((LocalFileStorage)element).getFile().toURI();
                return new DebuggerEditorInput(EFS.getStore((URI)fileUri));
            }
            catch (CoreException e) {
                DartUtil.logError(e);
            }
        }
        if (element instanceof ZipEntryStorage) {
            return new StorageEditorInput((IStorage)element){

                public boolean exists() {
                    return true;
                }
            };
        }
        if (element instanceof SDBGNoSourceFoundElement) {
            return new SDBGSourceNotFoundEditorInput((SDBGNoSourceFoundElement)element);
        }
        return null;
    }

    public Image getImage(Object element) {
        return this.getImage(element, null);
    }

    public Image getImage(Object element, IPresentationContext context) {
        try {
            if (element instanceof ISDBGVariable) {
                ISDBGVariable variable = (ISDBGVariable)element;
                if (variable.isThrownException()) {
                    return SDBGDebugUIPlugin.getImage("obj16/object_exception.png");
                }
                if (variable.isThisObject()) {
                    return SDBGDebugUIPlugin.getImage("obj16/object_this.png");
                }
                if (variable.isLibraryObject()) {
                    return SDBGDebugUIPlugin.getImage("obj16/object_library.png");
                }
                if (variable.isStatic() || variable.isScope() && "global".equals(variable.getName())) {
                    return SDBGDebugUIPlugin.getImage("obj16/object_static.png");
                }
                if (variable.isLocal() || variable.isScope() && "local".equals(variable.getName())) {
                    return SDBGDebugUIPlugin.getImage("obj16/object_local.gif");
                }
                return SDBGDebugUIPlugin.getImage("obj16/object_obj.png");
            }
            if (element instanceof ISDBGStackFrame) {
                ISDBGStackFrame frame = (ISDBGStackFrame)element;
                Image image = SDBGDebugUIPlugin.getImage("obj16/field_public.png");
                if (frame.isUsingSourceMaps()) {
                    DecorationOverlayIcon overlayDescriptor = new DecorationOverlayIcon(image, SDBGDebugUIPlugin.getImageDescriptor("ovr16/mapped.png"), 3);
                    image = SDBGDebugUIPlugin.getImage((ImageDescriptor)overlayDescriptor);
                }
                return image;
            }
            return null;
        }
        catch (Throwable t) {
            SDBGDebugUIPlugin.logError(t);
            return null;
        }
    }

    public Annotation getInstructionPointerAnnotation(IEditorPart editorPart, IStackFrame frame) {
        return null;
    }

    public String getInstructionPointerAnnotationType(IEditorPart editorPart, IStackFrame frame) {
        IExceptionStackFrame f;
        if (frame instanceof IExceptionStackFrame && (f = (IExceptionStackFrame)frame).hasException()) {
            return BREAK_ON_EXCEPTION_ANNOTAION;
        }
        return null;
    }

    public Image getInstructionPointerImage(IEditorPart editorPart, IStackFrame frame) {
        IExceptionStackFrame f;
        if (frame instanceof IExceptionStackFrame && (f = (IExceptionStackFrame)frame).hasException()) {
            return SDBGDebugUIPlugin.getImage("obj16/inst_ptr_exception.png");
        }
        try {
            IStackFrame topOfStack = frame.getThread().getTopStackFrame();
            if (frame.equals(topOfStack)) {
                return SDBGDebugUIPlugin.getImage("obj16/inst_ptr_current.png");
            }
        }
        catch (DebugException debugException) {}
        return SDBGDebugUIPlugin.getImage("obj16/inst_ptr_normal.png");
    }

    public String getInstructionPointerText(IEditorPart editorPart, IStackFrame frame) {
        IExceptionStackFrame f;
        if (frame instanceof IExceptionStackFrame && (f = (IExceptionStackFrame)frame).hasException()) {
            try {
                return f.getExceptionDisplayText();
            }
            catch (DebugException e) {
                DartUtil.logError(e);
            }
        }
        return null;
    }

    public String getText(Object element) {
        return this.getText(element, null);
    }

    public String getText(Object element, IPresentationContext context) {
        if (element instanceof IBreakpoint) {
            return this.getBreakpointText((IBreakpoint)element, context);
        }
        if (element instanceof IVariable) {
            return this.getVariableDetailText((IVariable)element, context);
        }
        if (element instanceof IValue) {
            return this.getValueDetailText((IValue)element, context);
        }
        return null;
    }

    public String getVariableDetailText(IVariable var, IPresentationContext context) {
        try {
            StringBuilder buff = new StringBuilder(this.getVariableName(var, context));
            String valueString = this.getValueDetailText(var.getValue(), context);
            if (valueString != null && valueString.length() != 0) {
                buff.append(" = ");
                buff.append(valueString);
            }
            return buff.toString();
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public String getVariableName(IVariable var, IPresentationContext context) {
        try {
            ISDBGVariable svar;
            if (var instanceof ISDBGVariable && (svar = (ISDBGVariable)var).isScope()) {
                return "(" + svar.getName() + ")";
            }
            ISDBGLogicalStructureTypeExtensions lstExtensions = this.getLogicalStructureTypeExtensions(var.getValue(), context);
            if (lstExtensions != null) {
                return lstExtensions.getVariableName(var);
            }
            return var.getName();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void setAttribute(String attribute, Object value) {
    }

    protected String getBreakpointText(IBreakpoint bp, IPresentationContext context) {
        try {
            String text;
            if (bp instanceof SDBGBreakpoint) {
                SDBGBreakpoint sdbgBreakpoint = (SDBGBreakpoint)bp;
                IFile file = sdbgBreakpoint.getFile();
                text = file != null ? String.valueOf(file.getProject().getName()) + ", " + file.getProjectRelativePath().toPortableString() + ", line " + NumberFormat.getNumberInstance().format(sdbgBreakpoint.getLine()) : String.valueOf(sdbgBreakpoint.getName()) + ", line " + NumberFormat.getNumberInstance().format(sdbgBreakpoint.getLine());
            } else {
                text = String.valueOf(bp.getMarker().getResource().getProject().getName()) + ", " + bp.getMarker().getResource().getProjectRelativePath().toPortableString();
                if (bp instanceof ILineBreakpoint) {
                    text = String.valueOf(text) + ", line " + NumberFormat.getNumberInstance().format(((ILineBreakpoint)bp).getLineNumber());
                    String lineInfo = this.getLineExtract((ILineBreakpoint)bp);
                    if (lineInfo != null) {
                        text = String.valueOf(text) + ", '" + lineInfo + "'";
                    }
                }
            }
            return text;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getValueDetailText(IValue value, IPresentationContext context) {
        block7: {
            try {
                if (value != null) break block7;
                return "<unknown value>";
            }
            catch (CoreException coreException) {
                return "<unknown value>";
            }
        }
        ISDBGLogicalStructureTypeExtensions lstExtensions = this.getLogicalStructureTypeExtensions(value, context);
        if (lstExtensions != null && lstExtensions.isValueDetailStringComputedByLogicalStructure(value)) {
            value = this.getLogicalValue(value, context);
        }
        if (value instanceof ISDBGValue && ((ISDBGValue)value).isPrimitive()) return value.getValueString();
        final CountDownLatch latch = new CountDownLatch(1);
        final String[] valueString = new String[1];
        this.computeDetail(value, new IValueDetailListener(){

            public void detailComputed(IValue value, String result) {
                valueString[0] = result;
                latch.countDown();
            }
        });
        try {
            latch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        if (!(value instanceof ISDBGValue) || !((ISDBGValue)value).isListValue()) return valueString[0];
        valueString[0] = "[" + valueString[0] + "]";
        return valueString[0];
    }

    protected String getValueText(IValue value, IPresentationContext context) throws CoreException {
        ISDBGLogicalStructureTypeExtensions lstExtensions = this.getLogicalStructureTypeExtensions(value, context);
        if (lstExtensions != null && lstExtensions.isValueStringComputedByLogicalStructure(value)) {
            value = this.getLogicalValue(value, context);
        }
        return value.getValueString();
    }

    private String getLineExtract(ILineBreakpoint bp) {
        try {
            InputStreamReader r = bp instanceof SDBGBreakpoint ? new InputStreamReader(((SDBGBreakpoint)bp).getContents(), ((SDBGBreakpoint)bp).getCharset()) : new InputStreamReader(((IFile)bp.getMarker().getResource()).getContents(), ((IFile)bp.getMarker().getResource()).getCharset());
            List lines = Streams.loadLinesAndClose((Reader)r);
            int line = bp.getLineNumber() - 1;
            if (line > 0 && line < lines.size()) {
                String lineStr = ((String)lines.get(line)).trim();
                return lineStr.length() == 0 ? null : lineStr;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    private ISDBGLogicalStructureTypeExtensions getLogicalStructureTypeExtensions(IValue value, IPresentationContext context) {
        ILogicalStructureType[] types;
        if (context != null && this.isShowLogicalStructure(context) && (types = DebugPlugin.getLogicalStructureTypes((IValue)value)).length > 0) {
            ILogicalStructureType type = DebugPlugin.getDefaultStructureType((ILogicalStructureType[])types);
            if (type instanceof ISDBGLogicalStructureTypeExtensions) {
                return (ISDBGLogicalStructureTypeExtensions)type;
            }
            if (type instanceof IAdaptable) {
                return (ISDBGLogicalStructureTypeExtensions)((IAdaptable)type).getAdapter(ISDBGLogicalStructureTypeExtensions.class);
            }
            if (type.getClass().getName().equals("org.eclipse.debug.internal.core.LogicalStructureType")) {
                try {
                    Method method = type.getClass().getDeclaredMethod("getDelegate", new Class[0]);
                    method.setAccessible(true);
                    Object delegateType = method.invoke((Object)type, new Object[0]);
                    if (delegateType instanceof ISDBGLogicalStructureTypeExtensions) {
                        return (ISDBGLogicalStructureTypeExtensions)delegateType;
                    }
                    if (delegateType instanceof IAdaptable) {
                        return (ISDBGLogicalStructureTypeExtensions)((IAdaptable)delegateType).getAdapter(ISDBGLogicalStructureTypeExtensions.class);
                    }
                }
                catch (Exception e) {
                    SDBGDebugUIPlugin.logError(e);
                    return null;
                }
            }
        }
        return null;
    }

    private IValue getLogicalValue(IValue value, IPresentationContext context) throws CoreException {
        return LOGICAL_VALUE_PROVIDER.getLogicalValue(value, context);
    }

    private Collection<ISourcePresentation> getSourcePresentations() {
        if (this.sourcePresentations == null) {
            this.sourcePresentations = new ArrayList<ISourcePresentation>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.github.sdbg.debug.ui.sourcePresentation");
            IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    this.sourcePresentations.add((ISourcePresentation)element.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    SDBGDebugCorePlugin.logError((Throwable)e);
                }
                ++n2;
            }
        }
        return this.sourcePresentations;
    }

    private boolean isShowLogicalStructure(IPresentationContext context) {
        Boolean show = (Boolean)context.getProperty("PRESENTATION_SHOW_LOGICAL_STRUCTURES");
        return show != null && show != false;
    }
}

