/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.preferences;

import com.github.sdbg.debug.core.SDBGDebugCorePlugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.github.sdbg.debug.debugPreferencePage";
    private Combo exceptionsCombo;
    private Button invokeToStringButton;
    private Button useSmartStepOverButton;
    private Button useSmartStepInOutButton;
    private Text excludeFromLogicalStructureText;

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    public boolean performOk() {
        SDBGDebugCorePlugin.getPlugin().setBreakOnExceptions(SDBGDebugCorePlugin.BreakOnExceptions.valueOf((String)this.exceptionsCombo.getText()));
        SDBGDebugCorePlugin.getPlugin().setInvokeToString(this.invokeToStringButton.getSelection());
        SDBGDebugCorePlugin.getPlugin().setUseSmartStepOver(this.useSmartStepOverButton.getSelection());
        SDBGDebugCorePlugin.getPlugin().setUseSmartStepInOut(this.useSmartStepInOutButton.getSelection());
        SDBGDebugCorePlugin.getPlugin().setExcludeFromLogicalStructure(this.excludeFromLogicalStructureText.getText());
        return true;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).indent(0, 10).align(4, 1).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().spacing(0, 8).margins(0, 10).applyTo(composite);
        Group group = new Group(composite, 0);
        group.setText("Debugging");
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(8, 8).applyTo((Composite)group);
        Label label = new Label((Composite)group, 0);
        label.setText("Break on exceptions:");
        label.pack();
        this.exceptionsCombo = new Combo((Composite)group, 12);
        this.exceptionsCombo.setItems(new String[]{SDBGDebugCorePlugin.BreakOnExceptions.none.toString(), SDBGDebugCorePlugin.BreakOnExceptions.uncaught.toString(), SDBGDebugCorePlugin.BreakOnExceptions.all.toString()});
        this.exceptionsCombo.select(this.exceptionsCombo.indexOf(SDBGDebugCorePlugin.getPlugin().getBreakOnExceptions().toString()));
        this.invokeToStringButton = new Button((Composite)group, 32);
        this.invokeToStringButton.setText("Invoke toString() methods when debugging");
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.invokeToStringButton);
        this.useSmartStepOverButton = new Button((Composite)group, 32);
        this.useSmartStepOverButton.setText("Execute the whole source language line when stepping-over");
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.useSmartStepOverButton);
        this.useSmartStepInOutButton = new Button((Composite)group, 32);
        this.useSmartStepInOutButton.setText("Skip non-sourcemapped JavaScript frames when stepping-in and out");
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.useSmartStepInOutButton);
        Label excludeFromLogicalStructureLabel = new Label((Composite)group, 0);
        excludeFromLogicalStructureLabel.setText("Objects to exclude from Logical Structure (regexp):");
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)excludeFromLogicalStructureLabel);
        this.excludeFromLogicalStructureText = new Text((Composite)group, 2048);
        GridDataFactory.swtDefaults().span(2, 1).align(4, 0x1000000).applyTo((Control)this.excludeFromLogicalStructureText);
        this.initFromPrefs();
        return composite;
    }

    private void initFromPrefs() {
        this.invokeToStringButton.setSelection(SDBGDebugCorePlugin.getPlugin().getInvokeToString());
        this.useSmartStepOverButton.setSelection(SDBGDebugCorePlugin.getPlugin().getUseSmartStepOver());
        this.useSmartStepInOutButton.setSelection(SDBGDebugCorePlugin.getPlugin().getUseSmartStepInOut());
        this.excludeFromLogicalStructureText.setText(SDBGDebugCorePlugin.getPlugin().getExcludeFromLogicalStructure());
    }
}

