/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.preferences;

import com.github.sdbg.debug.core.ChromeBrowserConfig;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

class BrowsersLabelProvider
extends DelegatingStyledCellLabelProvider
implements ILabelProvider {
    public BrowsersLabelProvider() {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new StyledLabelProvider());
    }

    public Image getImage(Object element) {
        StyledLabelProvider styledProvider = (StyledLabelProvider)this.getStyledStringProvider();
        return styledProvider.getImage(element);
    }

    public String getText(Object element) {
        StyledLabelProvider styledProvider = (StyledLabelProvider)this.getStyledStringProvider();
        return styledProvider.getMainText(element);
    }

    private static class StyledLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        public Image getImage(Object element) {
            if (element instanceof ChromeBrowserConfig) {
                return SDBGDebugUIPlugin.getImage("chromium_16.png");
            }
            return super.getImage(element);
        }

        public StyledString getStyledText(Object element) {
            String mainText = this.getMainText(element);
            String secondaryText = this.getSecondaryText(element);
            StyledString str = new StyledString();
            str.append(mainText);
            if (secondaryText != null) {
                str.append(secondaryText, StyledString.DECORATIONS_STYLER);
            }
            return str;
        }

        private String getMainText(Object element) {
            if (element instanceof ChromeBrowserConfig) {
                ChromeBrowserConfig browser = (ChromeBrowserConfig)element;
                return browser.getName();
            }
            return super.getText(element);
        }

        private String getSecondaryText(Object element) {
            if (element instanceof ChromeBrowserConfig) {
                ChromeBrowserConfig browser = (ChromeBrowserConfig)element;
                return " - " + browser.getPath();
            }
            return null;
        }
    }
}

