/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.objectinspector;

import com.github.sdbg.debug.core.model.ISDBGValue;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

class ValueLabelProvider
extends DelegatingStyledCellLabelProvider {
    public ValueLabelProvider() {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ValueStyledLabelProvider());
    }

    static class ValueStyledLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public StyledString getStyledText(Object element) {
            StyledString str = new StyledString();
            try {
                ISDBGValue debugValue;
                IVariable variable = (IVariable)element;
                IValue value = variable.getValue();
                str.append(value.getValueString());
                if (value instanceof ISDBGValue && (debugValue = (ISDBGValue)value).getId() != null) {
                    str.append(' ');
                    str.append("[id=" + debugValue.getId() + "]", StyledString.DECORATIONS_STYLER);
                }
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
            return str;
        }

        public String getText(Object element) {
            try {
                IVariable variable = (IVariable)element;
                IValue value = variable.getValue();
                return value.getValueString();
            }
            catch (DebugException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

