/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.objectinspector;

import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.objectinspector.ObjectInspectorView;
import com.github.sdbg.debug.ui.internal.util.SelectionUtil;
import com.github.sdbg.ui.instrumentation.UIInstrumentation;
import com.github.sdbg.ui.instrumentation.UIInstrumentationBuilder;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class OpenNewInspectorAction
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        if (this.selection != null) {
            UIInstrumentationBuilder instrumentation = UIInstrumentation.builder(this.getClass());
            try {
                instrumentation.record(this.selection);
                Object obj = SelectionUtil.getSingleElement(this.selection);
                if (obj instanceof IVariable) {
                    IVariable variable = (IVariable)obj;
                    try {
                        ObjectInspectorView.inspect(variable.getValue(), true);
                    }
                    catch (DebugException e) {
                        SDBGDebugUIPlugin.logError(e);
                    }
                } else if (obj instanceof IValue) {
                    IValue value = (IValue)obj;
                    ObjectInspectorView.inspect(value, true);
                }
                instrumentation.metric("Inspect", "Completed");
            }
            finally {
                instrumentation.log();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

