/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.objectinspector;

import com.github.sdbg.debug.core.model.ISDBGValue;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.objectinspector.ObjectInspectorView;
import com.github.sdbg.debug.ui.internal.util.SelectionUtil;
import com.github.sdbg.ui.instrumentation.UIInstrumentation;
import com.github.sdbg.ui.instrumentation.UIInstrumentationBuilder;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class OpenClassInspectorAction
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        if (this.selection != null) {
            UIInstrumentationBuilder instrumentation = UIInstrumentation.builder(this.getClass());
            Object obj = SelectionUtil.getSingleElement(this.selection);
            try {
                try {
                    instrumentation.record(this.selection);
                    if (obj instanceof IVariable) {
                        IVariable variable = (IVariable)obj;
                        obj = variable.getValue();
                    }
                    if (obj instanceof ISDBGValue) {
                        ISDBGValue cfr_ignored_0 = (ISDBGValue)obj;
                        IValue classValue = null;
                        if (classValue != null) {
                            ObjectInspectorView.inspect(classValue);
                        }
                    }
                    instrumentation.metric("Inspect", "Completed");
                }
                catch (DebugException e) {
                    SDBGDebugUIPlugin.logError(e);
                    instrumentation.log();
                }
            }
            finally {
                instrumentation.log();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

