/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.objectinspector;

import com.github.sdbg.debug.core.model.ISDBGValue;
import com.github.sdbg.debug.core.util.Base64;
import com.github.sdbg.debug.core.util.HistoryList;
import com.github.sdbg.debug.core.util.HistoryListListener;
import com.github.sdbg.debug.core.util.HistoryListMatcher;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.editors.JsSourceViewerConfiguration;
import com.github.sdbg.debug.ui.internal.objectinspector.ExpressionEvaluateJob;
import com.github.sdbg.debug.ui.internal.objectinspector.HistoryAction;
import com.github.sdbg.debug.ui.internal.objectinspector.InspectorVariable;
import com.github.sdbg.debug.ui.internal.objectinspector.NameLabelProvider;
import com.github.sdbg.debug.ui.internal.objectinspector.ObjectInspectorContentProvider;
import com.github.sdbg.debug.ui.internal.objectinspector.ObjectInspectorHistoryItem;
import com.github.sdbg.debug.ui.internal.objectinspector.ValueLabelProvider;
import com.github.sdbg.debug.ui.internal.presentation.SDBGDebugModelPresentation;
import com.github.sdbg.debug.ui.internal.util.SelectionUtil;
import com.github.sdbg.ui.instrumentation.UIInstrumentation;
import com.github.sdbg.ui.instrumentation.UIInstrumentationBuilder;
import com.github.sdbg.utilities.AdapterUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.texteditor.IUpdate;

public class ObjectInspectorView
extends ViewPart
implements IDebugEventSetListener,
IDebugContextListener {
    public static final String ID = "com.github.sdbg.debug.ui.objectInspectorView";
    private static SDBGDebugModelPresentation presentation = new SDBGDebugModelPresentation();
    private SashForm sashForm;
    private TreeViewer treeViewer;
    private UndoActionHandler undoAction;
    private RedoActionHandler redoAction;
    private IUndoContext undoContext;
    private SourceViewer sourceViewer;
    private Map<String, IUpdate> textActions = new HashMap<String, IUpdate>();
    private PrintItAction printItAction;
    private InspectItAction inspectItAction;
    private IMemento memento;
    private HistoryList<ObjectInspectorHistoryItem> historyList = new HistoryList();
    static Object EXPRESSION_EVAL_JOB_FAMILY = new Object();
    private static final String SASH_WEIGHTS = "sashWeights";
    private static final String COLUMN_WIDTHS = "columnWidths";

    public static void inspect(IValue value) {
        ObjectInspectorView.inspect(value, false);
    }

    public static void inspect(IValue value, boolean newInspector) {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            ObjectInspectorView view = newInspector ? (ObjectInspectorView)page.showView(ID, Integer.toString(new Random().nextInt()), 1) : (page.getActivePart() instanceof ObjectInspectorView ? (ObjectInspectorView)page.getActivePart() : (ObjectInspectorView)page.showView(ID));
            view.inspectValue(value);
        }
        catch (PartInitException e) {
            SDBGDebugUIPlugin.logError(e);
        }
    }

    protected static void inspectAsync(final IValue value) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ObjectInspectorView.inspect(value, false);
            }
        });
    }

    public void createPartControl(Composite parent) {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.getDebugContextService().addDebugContextListener((IDebugContextListener)this);
        this.sashForm = new SashForm(parent, 512);
        this.treeViewer = new TreeViewer((Composite)this.sashForm, 68100);
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new NameLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new ObjectInspectorContentProvider());
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                Object object = SelectionUtil.getSingleElement(sel);
                if (object instanceof IVariable) {
                    IVariable variable = (IVariable)object;
                    try {
                        presentation.computeDetail(variable.getValue(), new IValueDetailListener(){

                            public void detailComputed(IValue value, String result) {
                                ObjectInspectorView.this.updateStatusLine(result);
                            }
                        });
                    }
                    catch (DebugException e) {
                        SDBGDebugUIPlugin.logError(e);
                    }
                } else {
                    ObjectInspectorView.this.clearStatusLine();
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ObjectInspectorView.this.toggleExpansion(event.getSelection());
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        TreeViewerColumn nameColumn = new TreeViewerColumn(this.treeViewer, 16384);
        nameColumn.setLabelProvider((CellLabelProvider)new NameLabelProvider());
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setWidth(120);
        nameColumn.getColumn().setResizable(true);
        TreeViewerColumn valueColumn = new TreeViewerColumn(this.treeViewer, 16384);
        valueColumn.setLabelProvider((CellLabelProvider)new ValueLabelProvider());
        valueColumn.getColumn().setText("Value");
        valueColumn.getColumn().setWidth(140);
        valueColumn.getColumn().setResizable(true);
        Composite sourceContainer = new Composite((Composite)this.sashForm, 0);
        GridLayoutFactory.fillDefaults().applyTo(sourceContainer);
        Label label = new Label(sourceContainer, 0);
        label.setText("Enter expression to evaluate:");
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)label);
        this.sourceViewer = new SourceViewer(sourceContainer, null, 2624);
        this.sourceViewer.configure(this.getSourceViewerConfiguration());
        this.sourceViewer.setDocument(this.createDocument(), (IAnnotationModel)new AnnotationModel());
        this.sourceViewer.setUndoManager((IUndoManager)new TextViewerUndoManager(100));
        this.sourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.sourceViewer.getTextWidget().setTabs(2);
        this.sourceViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                if (e.character == '\r' && (e.stateMask & 0x60000) == 0) {
                    e.doit = false;
                    if (ObjectInspectorView.this.getCurrentSelection().isEmpty()) {
                        ObjectInspectorView.this.evaluateAndPrint(ObjectInspectorView.this.getCurrentLine());
                    } else {
                        ObjectInspectorView.this.evaluateAndPrint(ObjectInspectorView.this.getCurrentSelection());
                    }
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo(this.sourceViewer.getControl());
        this.sourceViewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                ObjectInspectorView.this.updateActions();
            }
        });
        this.sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ObjectInspectorView.this.updateActions();
            }
        });
        this.sourceViewer.activatePlugins();
        this.createActions();
        this.createGlobalActionHandlers();
        this.hookContextMenu();
        this.updateActions();
        this.configureToolBar(this.getViewSite().getActionBars().getToolBarManager());
        this.sashForm.setWeights(new int[]{60, 40});
        this.sashForm.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ObjectInspectorView.this.updateSashOrientation(ObjectInspectorView.this.sashForm);
            }
        });
        this.restoreState(this.memento);
        this.updateSashOrientation(this.sashForm);
        this.historyList.addListener((HistoryListListener)new HistoryListListener<ObjectInspectorHistoryItem>(){

            public void historyAboutToChange(final ObjectInspectorHistoryItem current) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ObjectInspectorView.this.saveSourceViewerInfo(current);
                    }
                });
            }

            public void historyChanged(ObjectInspectorHistoryItem current) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ObjectInspectorHistoryItem item = (ObjectInspectorHistoryItem)ObjectInspectorView.this.historyList.getCurrent();
                        ObjectInspectorView.this.inspectValueImpl(item != null && item.getValue() != null ? item.getValue() : null);
                        ObjectInspectorView.this.restoreSourceViewerInfo(item);
                    }
                });
            }
        });
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.syncDebugContext();
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.getDebugContextService().removeDebugContextListener((IDebugContextListener)this);
        super.dispose();
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getKind() == 8 && event.getSource() instanceof IDebugTarget) {
                this.syncDebugContext();
                this.handleDebugTargetTerminated((IDebugTarget)event.getSource());
            }
            ++n2;
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
        IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)this.getViewSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (progressService != null) {
            this.initProgressService(progressService);
        }
    }

    public void restoreState(IMemento memento) {
        if (memento != null) {
            String[] strs;
            if (memento.getString(SASH_WEIGHTS) != null && (strs = memento.getString(SASH_WEIGHTS).split(",")).length == 2) {
                try {
                    this.sashForm.setWeights(new int[]{Integer.parseInt(strs[0]), Integer.parseInt(strs[1])});
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (memento.getString(COLUMN_WIDTHS) != null) {
                strs = memento.getString(COLUMN_WIDTHS).split(",");
                int i = 0;
                while (i < strs.length) {
                    try {
                        this.treeViewer.getTree().getColumn(i).setWidth(Integer.parseInt(strs[i]));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    ++i;
                }
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        int[] weights = this.sashForm.getWeights();
        memento.putString(SASH_WEIGHTS, String.valueOf(weights[0]) + "," + weights[1]);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < this.treeViewer.getTree().getColumnCount()) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(this.treeViewer.getTree().getColumn(i).getWidth());
            ++i;
        }
        memento.putString(COLUMN_WIDTHS, builder.toString());
    }

    public void setFocus() {
        this.sourceViewer.getControl().setFocus();
    }

    protected void addTextAction(ActionFactory actionFactory, int textOperation) {
        IWorkbenchWindow window = this.getViewSite().getWorkbenchWindow();
        ActionFactory.IWorkbenchAction globalAction = actionFactory.create(window);
        TextViewerAction textAction = new TextViewerAction(textOperation);
        this.textActions.put(actionFactory.getId(), textAction);
        textAction.setText(globalAction.getText());
        textAction.setToolTipText(globalAction.getToolTipText());
        textAction.setDescription(globalAction.getDescription());
        textAction.setImageDescriptor(globalAction.getImageDescriptor());
        textAction.setDisabledImageDescriptor(globalAction.getDisabledImageDescriptor());
        textAction.setAccelerator(globalAction.getAccelerator());
        textAction.update();
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(actionFactory.getId(), (IAction)textAction);
    }

    protected void clearStatusLine() {
        this.setStatusLine(null);
    }

    protected void configureToolBar(IToolBarManager manager) {
        manager.add(HistoryAction.createForwardAction(this.historyList));
        manager.add(HistoryAction.createBackAction(this.historyList));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.printItAction);
        manager.add((IAction)this.inspectItAction);
        manager.update(true);
    }

    protected void evaluateAndPrint(String expression) {
        ISDBGValue value = this.getValue();
        if (value == null) {
            return;
        }
        ExpressionEvaluateJob job = new ExpressionEvaluateJob(this.getValue(), expression, new ExpressionEvaluateJob.ExpressionListener(){

            @Override
            public void watchEvaluationFinished(IWatchExpressionResult result, String stringValue) {
                if (result.hasErrors()) {
                    ObjectInspectorView.this.displayError(result);
                } else {
                    ObjectInspectorView.this.displayResult(stringValue);
                    ObjectInspectorView.this.resetCurrentValue();
                }
            }
        });
        job.schedule();
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.printItAction);
        manager.add((IAction)this.inspectItAction);
    }

    protected IAction getInspectItAction() {
        return this.inspectItAction;
    }

    protected IAction getPrintItAction() {
        return this.printItAction;
    }

    protected String getTextToEval() {
        if (this.getCurrentSelection().isEmpty()) {
            return this.getCurrentLine();
        }
        return this.getCurrentSelection();
    }

    protected boolean hasActiveConnection() {
        ISDBGValue value = this.getValue();
        if (value == null) {
            return false;
        }
        return !value.getDebugTarget().isTerminated();
    }

    protected void initProgressService(IWorkbenchSiteProgressService progressService) {
        progressService.showBusyForFamily(EXPRESSION_EVAL_JOB_FAMILY);
    }

    protected void inspectValue(IValue value) {
        this.historyList.add((Object)new ObjectInspectorHistoryItem(value));
    }

    protected void inspectValueImpl(IValue value) {
        if (value == null) {
            this.treeViewer.setInput((Object)new Object[0]);
        } else {
            presentation.computeDetail(value, new IValueDetailListener(){

                public void detailComputed(final IValue value, String result) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String typeName = value.getReferenceTypeName();
                                ObjectInspectorView.this.treeViewer.setInput((Object)new Object[]{new InspectorVariable(typeName, value)});
                            }
                            catch (DebugException debugException) {}
                        }
                    });
                }
            });
        }
    }

    protected void performEvaulation() {
        this.printItAction.run();
    }

    protected void removeTerminated() {
        this.historyList.removeMatching((HistoryListMatcher)new HistoryListMatcher<ObjectInspectorHistoryItem>(){

            public boolean matches(ObjectInspectorHistoryItem value) {
                return value.getValue().getDebugTarget().isTerminated();
            }
        });
    }

    protected void setStatusLine(String message) {
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    protected void toggleExpansion(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            boolean expanded = this.treeViewer.getExpandedState(sel);
            if (expanded) {
                this.treeViewer.collapseToLevel(sel, 1);
            } else {
                this.treeViewer.expandToLevel(sel, 1);
            }
        }
    }

    void updateSashOrientation(SashForm sash) {
        int orientation = 512;
        if (sash.getOrientation() != orientation) {
            sash.setOrientation(orientation);
        }
    }

    private void createActions() {
        this.printItAction = new PrintItAction();
        this.inspectItAction = new InspectItAction();
        this.textActions.put(this.printItAction.getId(), this.printItAction);
        this.textActions.put(this.inspectItAction.getId(), this.inspectItAction);
    }

    private IDocument createDocument() {
        Document document = new Document();
        return document;
    }

    private void createGlobalActionHandlers() {
        this.undoContext = ((IUndoManagerExtension)this.sourceViewer.getUndoManager()).getUndoContext();
        this.undoAction = new UndoActionHandler(this.getSite(), this.undoContext);
        this.redoAction = new RedoActionHandler(this.getSite(), this.undoContext);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        this.addTextAction(ActionFactory.CUT, 3);
        this.addTextAction(ActionFactory.COPY, 4);
        this.addTextAction(ActionFactory.PASTE, 5);
        this.addTextAction(ActionFactory.DELETE, 6);
        this.addTextAction(ActionFactory.SELECT_ALL, 7);
    }

    private void displayError(IWatchExpressionResult result) {
        this.displayResult(result.getErrorMessages()[0]);
    }

    private void displayResult(final String result) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IDocument document = ObjectInspectorView.this.sourceViewer.getDocument();
                String insert = result;
                if (insert == null) {
                    insert = "null";
                }
                try {
                    String current = document.get();
                    insert = "  " + insert;
                    if (!current.endsWith("\n")) {
                        insert = "\n" + insert;
                    }
                    if (!insert.endsWith("\n")) {
                        insert = String.valueOf(insert) + "\n";
                    }
                    document.replace(document.getLength(), 0, insert);
                    ObjectInspectorView.this.sourceViewer.setSelection((ISelection)new TextSelection(document.getLength(), 0), true);
                }
                catch (BadLocationException e) {
                    SDBGDebugUIPlugin.logError(e);
                }
            }
        });
    }

    private String getCurrentLine() {
        try {
            Point sel = this.sourceViewer.getSelectedRange();
            IDocument document = this.sourceViewer.getDocument();
            int line = document.getLineOfOffset(sel.x);
            int startOffset = document.getLineOffset(line);
            int lineLength = document.getLineLength(line);
            String text = document.get(startOffset, lineLength);
            return text.trim();
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private String getCurrentSelection() {
        return ((ITextSelection)this.sourceViewer.getSelection()).getText();
    }

    private IDebugContextService getDebugContextService() {
        return DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow());
    }

    private SourceViewerConfiguration getSourceViewerConfiguration() {
        return new JsSourceViewerConfiguration();
    }

    private ISDBGValue getValue() {
        Object input = this.treeViewer.getInput();
        if (input instanceof Object[]) {
            try {
                Object[] inputArray = (Object[])input;
                if (inputArray.length > 0) {
                    IVariable variable = (IVariable)inputArray[0];
                    return (ISDBGValue)variable.getValue();
                }
            }
            catch (DebugException debugException) {}
        }
        return null;
    }

    private void handleDebugTargetTerminated(IDebugTarget target) {
        this.removeTerminated();
    }

    private void hookContextMenu() {
        MenuManager treeMenuManager = new MenuManager("#PopupMenu");
        treeMenuManager.add((IContributionItem)new Separator("additions1"));
        treeMenuManager.add((IContributionItem)new Separator("additions2"));
        treeMenuManager.add((IContributionItem)new Separator("additions3"));
        Menu menu = treeMenuManager.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(treeMenuManager, (ISelectionProvider)this.treeViewer);
        MenuManager textMenuManager = new MenuManager("#SourcePopupMenu", "#SourcePopupMenu");
        textMenuManager.setRemoveAllWhenShown(true);
        textMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ObjectInspectorView.this.fillContextMenu(manager);
            }
        });
        menu = textMenuManager.createContextMenu(this.sourceViewer.getControl());
        this.sourceViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(textMenuManager.getId(), textMenuManager, (ISelectionProvider)this.sourceViewer);
    }

    private void resetCurrentValue() {
        ISDBGValue value = this.getValue();
        if (value != null) {
            value.reset();
            this.inspectValueImpl((IValue)value);
        }
    }

    private void restoreSourceViewerInfo(ObjectInspectorHistoryItem item) {
        this.sourceViewer.getDocument().set(item == null ? "" : item.getText());
        if (item != null) {
            if (item.getSelection() != null) {
                this.sourceViewer.setSelection(item.getSelection());
            }
            this.sourceViewer.setTopIndex(item.getTopIndex());
        }
    }

    private void saveSourceViewerInfo(ObjectInspectorHistoryItem item) {
        item.setText(this.sourceViewer.getDocument().get());
        item.setSelection(this.sourceViewer.getSelection());
        item.setTopIndex(this.sourceViewer.getTopIndex());
    }

    private void syncDebugContext() {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Object context = null;
                    ISelection sel = ObjectInspectorView.this.getDebugContextService().getActiveContext();
                    if (sel instanceof IStructuredSelection) {
                        context = ((IStructuredSelection)sel).getFirstElement();
                    }
                    IThread cfr_ignored_0 = (IThread)AdapterUtilities.getAdapter(context, IThread.class);
                    ObjectInspectorView.this.updateActions();
                }
            });
        }
    }

    private void updateActions() {
        for (IUpdate action : this.textActions.values()) {
            action.update();
        }
    }

    private void updateStatusLine(final String message) {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ObjectInspectorView.this.setStatusLine(message);
                }
            });
        }
    }

    private class InspectItAction
    extends Action
    implements IUpdate {
        public InspectItAction() {
            super("Inspect It...", SDBGDebugUIPlugin.getImageDescriptor("obj16/watchlist_view.gif"));
            this.setId(this.getText());
        }

        public void run() {
            String selection = ObjectInspectorView.this.getTextToEval();
            final UIInstrumentationBuilder instrumentation = UIInstrumentation.builder(((Object)((Object)this)).getClass());
            instrumentation.record((ITextSelection)new TextSelection((IDocument)new Document(selection), 0, selection.length()));
            ExpressionEvaluateJob job = new ExpressionEvaluateJob(ObjectInspectorView.this.getValue(), selection, new ExpressionEvaluateJob.ExpressionListener(){

                @Override
                public void watchEvaluationFinished(IWatchExpressionResult result, String stringValue) {
                    try {
                        if (result.hasErrors()) {
                            ObjectInspectorView.this.displayError(result);
                        } else {
                            ObjectInspectorView.inspectAsync(result.getValue());
                            instrumentation.data("InspectResult", Base64.encodeToString((byte[])String.valueOf(result.getValue()).getBytes(), (int)0));
                        }
                        instrumentation.metric("Evaluate", "Completed");
                    }
                    finally {
                        instrumentation.log();
                    }
                }
            });
            job.schedule();
        }

        public void update() {
            this.setEnabled(ObjectInspectorView.this.hasActiveConnection());
        }
    }

    private class PrintItAction
    extends Action
    implements IUpdate {
        public PrintItAction() {
            super("Print It", SDBGDebugUIPlugin.getImageDescriptor("obj16/variable_tab.gif"));
            this.setId(this.getText());
        }

        public void run() {
            String selection = ObjectInspectorView.this.getTextToEval();
            final UIInstrumentationBuilder instrumentation = UIInstrumentation.builder(((Object)((Object)this)).getClass());
            instrumentation.record((ITextSelection)new TextSelection((IDocument)new Document(selection), 0, selection.length()));
            ExpressionEvaluateJob job = new ExpressionEvaluateJob(ObjectInspectorView.this.getValue(), selection, new ExpressionEvaluateJob.ExpressionListener(){

                @Override
                public void watchEvaluationFinished(IWatchExpressionResult result, String stringValue) {
                    try {
                        if (result.hasErrors()) {
                            ObjectInspectorView.this.displayError(result);
                        } else {
                            ObjectInspectorView.this.displayResult(stringValue);
                            ObjectInspectorView.this.resetCurrentValue();
                            instrumentation.data("EvaluateResult", Base64.encodeToString((byte[])String.valueOf(result.getValue()).getBytes(), (int)0));
                        }
                        instrumentation.metric("Evaluate", "Completed");
                    }
                    finally {
                        instrumentation.log();
                    }
                }
            });
            job.schedule();
        }

        public void update() {
            this.setEnabled(ObjectInspectorView.this.hasActiveConnection());
        }
    }

    class TextViewerAction
    extends Action
    implements IUpdate {
        private int actionId;

        TextViewerAction(int actionId) {
            this.actionId = actionId;
        }

        public boolean isEnabled() {
            return ObjectInspectorView.this.sourceViewer.canDoOperation(this.actionId);
        }

        public void run() {
            ObjectInspectorView.this.sourceViewer.doOperation(this.actionId);
            ObjectInspectorView.this.updateActions();
        }

        public void update() {
            if (super.isEnabled() != this.isEnabled()) {
                this.setEnabled(this.isEnabled());
            }
        }
    }
}

