/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.objectinspector;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ObjectInspectorContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        IVariable variable = (IVariable)element;
        try {
            IIndexedValue indexedValue;
            int partitionSize;
            IValue value = variable.getValue();
            if (value instanceof IIndexedValue && (partitionSize = this.computeParitionSize(indexedValue = (IIndexedValue)value)) > 1) {
                int offset = indexedValue.getInitialOffset();
                int length = indexedValue.getSize();
                int numPartitions = length / partitionSize;
                int remainder = length % partitionSize;
                if (remainder > 0) {
                    ++numPartitions;
                }
                Object[] partitions = new IVariable[numPartitions];
                int i = 0;
                while (i < numPartitions - 1) {
                    partitions[i] = new IndexedVariablePartition((IDebugElement)variable, indexedValue, offset, partitionSize);
                    offset += partitionSize;
                    ++i;
                }
                if (remainder == 0) {
                    remainder = partitionSize;
                }
                partitions[numPartitions - 1] = new IndexedVariablePartition((IDebugElement)variable, indexedValue, offset, remainder);
                return partitions;
            }
            return value.getVariables();
        }
        catch (DebugException ex) {
            ex.printStackTrace();
            return EMPTY;
        }
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = (Object[])inputElement;
        return elements == null ? EMPTY : elements;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected int computeParitionSize(IIndexedValue value) {
        int partitionSize = 1;
        try {
            int length = value.getSize();
            int partitionDepth = 0;
            int preferredSize = this.getArrayPartitionSize();
            int remainder = length % preferredSize;
            length /= preferredSize;
            while (length > 0) {
                if (remainder == 0 && length == 1) break;
                ++partitionDepth;
                remainder = length % preferredSize;
                length /= preferredSize;
            }
            int i = 0;
            while (i < partitionDepth) {
                partitionSize *= preferredSize;
                ++i;
            }
        }
        catch (DebugException debugException) {}
        return partitionSize;
    }

    protected int getArrayPartitionSize() {
        return 100;
    }
}

