/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.objectinspector;

import com.github.sdbg.debug.core.model.ISDBGValue;
import com.github.sdbg.debug.core.model.ISDBGVariable;
import com.github.sdbg.debug.ui.internal.objectinspector.InspectorVariable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ui.IActionFilter;

public class InspectorActionFilter
implements IActionFilter {
    public static void registerAdapters() {
        IAdapterManager manager = Platform.getAdapterManager();
        InspectorAdapterFactory factory = new InspectorAdapterFactory();
        manager.registerAdapters((IAdapterFactory)factory, ISDBGVariable.class);
        manager.registerAdapters((IAdapterFactory)factory, InspectorVariable.class);
    }

    public boolean testAttribute(Object object, String name, String value) {
        if ("isInspectableObject".equals(name)) {
            return Boolean.toString(this.isInspectableObject(object)).equals(value);
        }
        if ("canInspectObject".equals(name)) {
            return Boolean.toString(this.canInspectObject(object)).equals(value);
        }
        if ("canInspectClass".equals(name)) {
            return Boolean.toString(this.canInspectClass(object)).equals(value);
        }
        if ("canInspectLibrary".equals(name)) {
            return Boolean.toString(this.canInspectLibrary(object)).equals(value);
        }
        return false;
    }

    private boolean canInspectClass(Object object) {
        if (!this.isInspectableObject(object)) {
            return false;
        }
        if (object instanceof IVariable) {
            IVariable variable = (IVariable)object;
            try {
                object = variable.getValue();
            }
            catch (DebugException debugException) {
                return false;
            }
        }
        return !this.isPrimitive(object);
    }

    private boolean canInspectLibrary(Object object) {
        if (!this.isInspectableObject(object)) {
            return false;
        }
        if (object instanceof IVariable) {
            IVariable variable = (IVariable)object;
            try {
                object = variable.getValue();
            }
            catch (DebugException debugException) {
                return false;
            }
        }
        return !this.isPrimitive(object);
    }

    private boolean canInspectObject(Object object) {
        if (!this.isInspectableObject(object)) {
            return false;
        }
        return !(object instanceof InspectorVariable);
    }

    private boolean isInspectableObject(Object object) {
        return object instanceof ISDBGVariable || object instanceof InspectorVariable;
    }

    private boolean isPrimitive(Object object) {
        ISDBGValue val;
        return object instanceof ISDBGValue && (val = (ISDBGValue)object).isPrimitive();
    }

    static class InspectorAdapterFactory
    implements IAdapterFactory {
        private InspectorActionFilter inspectorFilter = new InspectorActionFilter();

        public Object getAdapter(Object adaptableObject, Class adapterType) {
            return this.inspectorFilter;
        }

        public Class[] getAdapterList() {
            return new Class[]{IActionFilter.class};
        }
    }
}

