/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.objectinspector;

import com.github.sdbg.debug.core.util.HistoryList;
import com.github.sdbg.debug.core.util.HistoryListListener;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import org.eclipse.jface.action.Action;

class HistoryAction<T>
extends Action
implements HistoryListListener<T> {
    private HistoryList<T> historyList;
    private boolean isForwardAction;

    public static <E> HistoryAction<E> createBackAction(HistoryList<E> historyList) {
        return new HistoryAction<E>(historyList, true);
    }

    public static <E> HistoryAction<E> createForwardAction(HistoryList<E> historyList) {
        return new HistoryAction<E>(historyList, false);
    }

    private HistoryAction(HistoryList<T> historyList, boolean isForwardAction) {
        super(isForwardAction ? "Forward" : "Back", isForwardAction ? SDBGDebugUIPlugin.getImageDescriptor("obj16/forward_nav.gif") : SDBGDebugUIPlugin.getImageDescriptor("obj16/backward_nav.gif"));
        this.historyList = historyList;
        this.isForwardAction = isForwardAction;
        this.updateEnablement();
        historyList.addListener((HistoryListListener)this);
    }

    public void historyAboutToChange(T current) {
    }

    public void historyChanged(T current) {
        this.updateEnablement();
    }

    public void run() {
        if (this.isForwardAction) {
            this.historyList.navigateNext();
        } else {
            this.historyList.navigatePrevious();
        }
    }

    private void updateEnablement() {
        if (this.isForwardAction) {
            this.setEnabled(this.historyList.hasNext());
        } else {
            this.setEnabled(this.historyList.hasPrevious());
        }
    }
}

