/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.objectinspector;

import com.github.sdbg.debug.core.model.ISDBGValue;
import com.github.sdbg.debug.ui.internal.objectinspector.ObjectInspectorView;
import com.github.sdbg.debug.ui.internal.presentation.SDBGDebugModelPresentation;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.debug.ui.IValueDetailListener;

class ExpressionEvaluateJob
extends Job {
    private static SDBGDebugModelPresentation presentation = new SDBGDebugModelPresentation();
    private ISDBGValue value;
    private String expression;
    private ExpressionListener callback;

    public ExpressionEvaluateJob(ISDBGValue value, String expression, ExpressionListener callback) {
        super("Evaluating...");
        this.value = value;
        this.expression = expression;
        this.callback = callback;
        this.setUser(false);
    }

    public boolean belongsTo(Object family) {
        return family == ObjectInspectorView.EXPRESSION_EVAL_JOB_FAMILY;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.expression == null || this.expression.length() == 0) {
            return Status.OK_STATUS;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final IWatchExpressionResult[] expResult = new IWatchExpressionResult[1];
        final String[] stringValue = new String[1];
        this.value.evaluateExpression(this.expression, new IWatchExpressionListener(){

            public void watchEvaluationFinished(IWatchExpressionResult result) {
                expResult[0] = result;
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {}
        if (this.callback != null) {
            IWatchExpressionResult result = expResult[0];
            if (result.getValue() != null) {
                final CountDownLatch latch2 = new CountDownLatch(1);
                presentation.computeDetail(result.getValue(), new IValueDetailListener(){

                    public void detailComputed(IValue value, String strResult) {
                        stringValue[0] = strResult;
                        latch2.countDown();
                    }
                });
                try {
                    latch2.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.callback.watchEvaluationFinished(result, stringValue[0]);
        }
        return Status.OK_STATUS;
    }

    static interface ExpressionListener {
        public void watchEvaluationFinished(IWatchExpressionResult var1, String var2);
    }
}

