/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.launch;

import com.github.sdbg.debug.ui.internal.DartUtil;
import com.github.sdbg.debug.ui.internal.DebugErrorHandler;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.launch.RunAbstractAction;
import com.github.sdbg.debug.ui.internal.util.LaunchUtils;
import com.github.sdbg.ui.instrumentation.UIInstrumentationBuilder;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class RunLastAction
extends RunAbstractAction {
    public RunLastAction(IWorkbenchWindow window) {
        this(window, false);
    }

    public RunLastAction(IWorkbenchWindow window, boolean noMenu) {
        super(window, "Run", noMenu ? 1 : 4);
        this.setActionDefinitionId("com.github.sdbg.debug.ui.run.last");
        this.setImageDescriptor(SDBGDebugUIPlugin.getImageDescriptor("obj16/run_exc.png"));
    }

    public RunLastAction(IWorkbenchWindow window, String name, int flags) {
        super(window, name, flags);
    }

    @Override
    protected void doLaunch(UIInstrumentationBuilder instrumentation) {
        try {
            List<ILaunchConfiguration> launches = LaunchUtils.getAllLaunches();
            instrumentation.metric("launches-count", launches.size());
            if (launches.size() != 0) {
                ILaunchConfiguration launchConfig = LaunchUtils.chooseLatest(launches);
                if (launchConfig != null) {
                    this.launch(launchConfig, instrumentation);
                } else {
                    instrumentation.metric("Problem", "Launch config was null");
                }
            } else {
                MessageDialog.openInformation((Shell)this.window.getShell(), (String)"Unable to Run", (String)"Unable to run current selection - please select a runnable resource.");
            }
        }
        catch (Throwable exception) {
            instrumentation.metric("Problem-Exception", exception.getClass().toString());
            instrumentation.data("Problem-Exception", exception.toString());
            DartUtil.logError(exception);
            DebugErrorHandler.errorDialog(this.window.getShell(), "Error During Launch", "Internal error during launch - please report this using the feedback mechanism!", exception);
        }
    }
}

