/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.launch;

import com.github.sdbg.debug.ui.internal.DebugErrorHandler;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.launch.RunAbstractAction;
import com.github.sdbg.debug.ui.internal.util.LaunchUtils;
import com.github.sdbg.ui.instrumentation.UIInstrumentationBuilder;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

public class RunInChromeAction
extends RunAbstractAction {
    public RunInChromeAction() {
        this((IWorkbenchWindow)null);
    }

    public RunInChromeAction(IWorkbenchWindow window) {
        this(window, false);
    }

    public RunInChromeAction(IWorkbenchWindow window, boolean noMenu) {
        super(window, "Run in Chrome", noMenu ? 1 : 4);
        this.setActionDefinitionId("com.github.sdbg.tools.debug.ui.run.chrome");
        this.setImageDescriptor(SDBGDebugUIPlugin.getImageDescriptor("obj16/run_exc.png"));
    }

    @Override
    protected void doLaunch(UIInstrumentationBuilder instrumentation) {
        IResource resource = LaunchUtils.getSelectedResource(this.window);
        if (resource == null) {
            return;
        }
        try {
            instrumentation.metric("Resource-Class", resource.getClass().toString());
            instrumentation.data("Resource-Name", resource.getName());
            ILaunchShortcut shortcut = LaunchUtils.getChromeLaunchShortcut();
            StructuredSelection selection = new StructuredSelection((Object)resource);
            this.launch(shortcut, (ISelection)selection, instrumentation);
        }
        catch (Exception exception) {
            instrumentation.metric("Problem", "Exception launching " + exception.getClass().toString());
            instrumentation.data("Problem", "Exception launching " + exception.toString());
            DebugErrorHandler.errorDialog(this.window.getShell(), "Error Launching", "Unable to launch " + resource.getName() + ".", exception);
        }
    }
}

