/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.launch;

import com.github.sdbg.debug.core.SDBGDebugCorePlugin;
import com.github.sdbg.debug.core.util.ResourceServer;
import com.github.sdbg.debug.core.util.ResourceServerManager;
import com.github.sdbg.debug.ui.internal.DebugErrorHandler;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.launch.RunAbstractAction;
import com.github.sdbg.debug.ui.internal.util.LaunchUtils;
import com.github.sdbg.ui.instrumentation.UIInstrumentationBuilder;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IWorkbenchWindow;

public class RunInBrowserAction
extends RunAbstractAction {
    public RunInBrowserAction() {
        this((IWorkbenchWindow)null);
    }

    public RunInBrowserAction(IWorkbenchWindow window) {
        this(window, false);
    }

    public RunInBrowserAction(IWorkbenchWindow window, boolean noMenu) {
        super(window, "Run in Browser", noMenu ? 1 : 4);
        this.setActionDefinitionId("com.google.dart.tools.debug.ui.run.browser");
        this.setImageDescriptor(SDBGDebugUIPlugin.getImageDescriptor("obj16/run_exc.png"));
    }

    @Override
    protected void doLaunch(UIInstrumentationBuilder instrumentation) {
        IResource resource = LaunchUtils.getSelectedResource(this.window);
        try {
            if (resource != null) {
                instrumentation.metric("Resource-Class", resource.getClass().toString());
                instrumentation.data("Resource-Name", resource.getName());
                ResourceServer server = ResourceServerManager.getServer();
                String url = server.getUrlForResource(resource);
                if (SDBGDebugCorePlugin.getPlugin().getIsDefaultBrowser()) {
                    LaunchUtils.openBrowser(url);
                } else {
                    LaunchUtils.launchInExternalBrowser(url);
                }
            }
        }
        catch (Exception exception) {
            instrumentation.metric("Problem", "Exception launching " + exception.getClass().toString());
            instrumentation.data("Problem", "Exception launching " + exception.toString());
            DebugErrorHandler.errorDialog(this.window.getShell(), "Error Launching", "Unable to launch " + resource.getName() + ".", exception);
        }
    }
}

