/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.launch;

import com.github.sdbg.debug.ui.internal.DartUtil;
import com.github.sdbg.debug.ui.internal.DebugErrorHandler;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.launch.RunAbstractAction;
import com.github.sdbg.debug.ui.internal.launch.RunLastAction;
import com.github.sdbg.debug.ui.internal.launch.SetRunLastLaunchHandler;
import com.github.sdbg.debug.ui.internal.util.LaunchUtils;
import com.github.sdbg.ui.instrumentation.UIInstrumentationBuilder;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class RunAction
extends RunAbstractAction
implements IViewActionDelegate {
    private static boolean runLastLaunch = RunAction.initRunLastLaunch();

    public static void setRunLastLaunch(boolean runLastLaunchValue) {
        runLastLaunch = runLastLaunchValue;
    }

    private static boolean initRunLastLaunch() {
        ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = cmdService.getCommand(SetRunLastLaunchHandler.commandId);
        if (command != null) {
            return (Boolean)command.getState("org.eclipse.ui.commands.toggleState").getValue();
        }
        return false;
    }

    public RunAction(IWorkbenchWindow window) {
        this(window, false);
    }

    public RunAction(IWorkbenchWindow window, boolean noMenu) {
        super(window, "Run", noMenu ? 1 : 4);
        this.setActionDefinitionId("com.github.sdbg.debug.ui.run.selection");
        this.setImageDescriptor(SDBGDebugUIPlugin.getImageDescriptor("obj16/run_exc.png"));
        this.setToolTipText("Run");
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void init(IViewPart view) {
    }

    @Override
    protected void doLaunch(UIInstrumentationBuilder instrumentation) {
        if (runLastLaunch) {
            RunLastAction runLastAction = new RunLastAction(this.window);
            runLastAction.run();
            return;
        }
        try {
            IResource resource = LaunchUtils.getSelectedResource(this.window);
            if (resource != null) {
                instrumentation.metric("Resource-Class", resource.getClass().toString());
                instrumentation.data("Resource-Name", resource.getName());
                this.launchResource(resource, instrumentation);
            } else {
                List<ILaunchConfiguration> launches = LaunchUtils.getAllLaunches();
                instrumentation.metric("Launches-Count", launches.size());
                if (launches.size() == 0) {
                    instrumentation.metric("Problem", "Unable to run, not a library with a main, showing dialog");
                    MessageDialog.openInformation((Shell)this.getWindow().getShell(), (String)"Unable to Run", (String)"Unable to run the current selection. Please choose a file in a library with a main() function.");
                } else if (!this.chooseAndLaunch(launches, instrumentation)) {
                    MessageDialog.openInformation((Shell)this.getWindow().getShell(), (String)"Unable to Run", (String)"Could not find a launch configuration.");
                }
            }
        }
        catch (CoreException ce) {
            instrumentation.metric("Problem", "Exception launching " + ((Object)((Object)ce)).getClass().toString());
            instrumentation.data("Problem", "Exception launching " + ce.toString());
            DartUtil.logError(ce);
            DebugErrorHandler.errorDialog(this.window.getShell(), "Error Launching Application", ce.getStatus().getMessage(), ce.getStatus());
        }
        catch (Throwable exception) {
            instrumentation.metric("Problem", "Exception launching " + exception.getClass().toString());
            instrumentation.data("Problem", "Exception launching " + exception.toString());
            DartUtil.logError(exception);
            DebugErrorHandler.errorDialog(this.window.getShell(), "Error Launching Application", exception.getMessage(), exception);
        }
    }

    protected void launchResource(IResource resource, UIInstrumentationBuilder instrumentation) throws CoreException {
        ILaunchConfiguration config = null;
        if (resource instanceof IProject && (config = LaunchUtils.getLaunchForProject((IProject)resource)) != null) {
            this.launch(config, instrumentation);
            return;
        }
        List<ILaunchShortcut> candidates = LaunchUtils.getApplicableLaunchShortcuts(resource);
        if (candidates.size() == 0) {
            RunLastAction runLastAction = new RunLastAction(this.getWindow(), true);
            runLastAction.run();
        } else {
            StructuredSelection sel = new StructuredSelection((Object)resource);
            this.launch(candidates.get(0), (ISelection)sel, instrumentation);
        }
    }

    private boolean chooseAndLaunch(List<ILaunchConfiguration> launches, UIInstrumentationBuilder instrumentation) {
        if (launches.size() == 0) {
            return false;
        }
        if (launches.size() == 1) {
            this.launch(launches.get(0), instrumentation);
            return true;
        }
        ILaunchConfiguration config = LaunchUtils.chooseConfiguration(launches);
        if (config != null) {
            this.launch(config, instrumentation);
            return true;
        }
        instrumentation.metric("Problem", "Config was null");
        return false;
    }
}

