/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.launch;

import com.github.sdbg.debug.core.SDBGDebugCorePlugin;
import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.DebugErrorHandler;
import com.github.sdbg.debug.ui.internal.DebugInstrumentationUtilities;
import com.github.sdbg.debug.ui.internal.util.LaunchUtils;
import com.github.sdbg.ui.actions.InstrumentedAction;
import com.github.sdbg.ui.instrumentation.UIInstrumentationBuilder;
import com.github.sdbg.utilities.instrumentation.InstrumentationBuilder;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

public abstract class RunAbstractAction
extends InstrumentedAction
implements IWorkbenchWindowPulldownDelegate2,
IMenuCreator {
    private static final int MAX_MENU_LENGTH = 10;
    private Menu menu;
    protected IWorkbenchWindow window;

    public RunAbstractAction(IWorkbenchWindow window, String name, int flags) {
        super(name, flags);
        this.window = window;
        if ((flags & 4) != 0) {
            this.setMenuCreator(this);
        }
    }

    public void dispose() {
        this.setMenu(null);
    }

    public Menu getMenu(Control parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.menu);
        this.initMenu();
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.menu);
        this.initMenu();
        return this.menu;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected abstract void doLaunch(UIInstrumentationBuilder var1);

    @Override
    protected final void doRun(Event event, UIInstrumentationBuilder instrumentation) {
        if (event == null) {
            this.doLaunch(instrumentation);
            return;
        }
        if ((event.stateMask & SWT.MOD1) <= 0 || event.type == 1) {
            this.doLaunch(instrumentation);
            return;
        }
        instrumentation.metric("Skipped", "The Menu was opened");
    }

    protected IWorkbenchWindow getWindow() {
        return this.window;
    }

    protected void launch(ILaunchConfiguration config, UIInstrumentationBuilder instrumentation) {
        String mode = "run";
        instrumentation.metric("Launch mode", mode);
        try {
            if (config.supportsMode("debug")) {
                mode = "debug";
            }
            if (config.getType().getIdentifier().equals("com.github.sdbg.debug.core.chromeLaunchConfig")) {
                SDBGLaunchConfigWrapper launchConfig = new SDBGLaunchConfigWrapper(config);
                DebugInstrumentationUtilities.recordLaunchConfiguration(launchConfig, (InstrumentationBuilder)instrumentation);
                launchConfig.markAsLaunched();
                LaunchUtils.clearConsoles();
            }
            LaunchUtils.launch(config, mode);
        }
        catch (CoreException e) {
            instrumentation.metric("Problem-Exception", ((Object)((Object)e)).getClass().getName());
            instrumentation.metric("Problem-Exception", e.toString());
            SDBGDebugCorePlugin.logError((Throwable)e);
            DebugErrorHandler.errorDialog(this.window.getShell(), "Error Launching Application", e.getMessage(), e);
        }
    }

    protected void launch(ILaunchShortcut shortcut, ISelection selection, UIInstrumentationBuilder instrumentation) {
        instrumentation.record(selection);
        shortcut.launch(selection, "debug");
    }

    private void fillMenu(Menu menu) {
        ILaunchConfiguration[] launches = LaunchUtils.getAllLaunchesArray();
        Arrays.sort(launches, new LaunchConfigComparator());
        int count = Math.min(launches.length, 10);
        int i = 0;
        while (i < count) {
            final ILaunchConfiguration config = launches[i];
            InstrumentedAction launchAction = new InstrumentedAction(LaunchUtils.getLongLaunchName(config), DebugUITools.getDefaultImageDescriptor((Object)config)){

                @Override
                public void doRun(Event event, UIInstrumentationBuilder instrumentation) {
                    RunAbstractAction.this.launch(config, instrumentation);
                }
            };
            new ActionContributionItem((IAction)launchAction).fill(menu, -1);
            ++i;
        }
        if (menu.getItemCount() > 0) {
            new Separator().fill(menu, -1);
        }
    }

    private void initMenu() {
    }

    private void setMenu(Menu inMenu) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = inMenu;
    }

    private static class LaunchConfigComparator
    implements Comparator<ILaunchConfiguration> {
        private LaunchConfigComparator() {
        }

        @Override
        public int compare(ILaunchConfiguration o1, ILaunchConfiguration o2) {
            SDBGLaunchConfigWrapper wrapper1 = new SDBGLaunchConfigWrapper(o1);
            SDBGLaunchConfigWrapper wrapper2 = new SDBGLaunchConfigWrapper(o2);
            long compare = wrapper2.getLastLaunchTime() - wrapper1.getLastLaunchTime();
            if (compare < 0L) {
                return -1;
            }
            return compare == 0L ? 0 : 1;
        }
    }
}

