/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.launch;

import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class LaunchesRenameResourceParticipant
extends RenameParticipant {
    private IFile file;
    private List<ILaunchConfiguration> launchConfigs;

    private static List<ILaunchConfiguration> getLaunchesForFile(IFile file) throws CoreException {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations();
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            SDBGLaunchConfigWrapper wrapper = new SDBGLaunchConfigWrapper(config);
            IResource launchedResource = wrapper.getApplicationResource();
            if (launchedResource != null && launchedResource.equals((Object)file)) {
                configs.add(config);
            }
            ++n2;
        }
        return configs;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        String newName = this.getArguments().getNewName();
        IFile newFile = this.file.getParent().getFile((IPath)new Path(newName));
        return new UpdateLaunchConfigurations(this.launchConfigs, newFile.getFullPath().toPortableString());
    }

    public String getName() {
        return "Rename Dart launches";
    }

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            this.file = (IFile)element;
            try {
                this.launchConfigs = LaunchesRenameResourceParticipant.getLaunchesForFile(this.file);
            }
            catch (CoreException coreException) {
                return false;
            }
            return this.launchConfigs.size() > 0;
        }
        return false;
    }

    private static class UpdateLaunchConfigurations
    extends NullChange {
        private final List<ILaunchConfiguration> configurations;
        private final String newName;
        private final String oldName;

        public UpdateLaunchConfigurations(List<ILaunchConfiguration> configurations, String newName) {
            super("Update launch configuration");
            this.configurations = configurations;
            this.newName = newName;
            this.oldName = new SDBGLaunchConfigWrapper(configurations.get(0)).getApplicationName();
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            for (ILaunchConfiguration config : this.configurations) {
                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                SDBGLaunchConfigWrapper wrapper = new SDBGLaunchConfigWrapper((ILaunchConfiguration)wc);
                wrapper.setApplicationName(this.newName);
                wc.doSave();
            }
            return new UpdateLaunchConfigurations(this.configurations, this.oldName);
        }
    }
}

