/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.launch;

import com.github.sdbg.debug.ui.internal.util.LaunchUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class LaunchService {
    private final List<LaunchListener> listeners = new ArrayList<LaunchListener>();
    private final ILaunchesListener2 debugLaunchListener = new ILaunchesListener2(){

        public void launchesAdded(ILaunch[] launches) {
            LaunchService.this.notifyLaunchStarted(launches);
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        public void launchesTerminated(ILaunch[] launches) {
            LaunchService.this.notifyLaunchTerminated(launches);
        }
    };
    private static LaunchService instance;

    public static LaunchService getInstance() {
        if (instance == null) {
            instance = new LaunchService();
        }
        return instance;
    }

    private LaunchService() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.debugLaunchListener);
    }

    public void addListener(LaunchListener listener) {
        this.listeners.add(listener);
    }

    public void launchInChrome(IResource resource) {
        this.launch(resource, LaunchUtils.getChromeLaunchShortcut());
    }

    public void removeListener(LaunchListener listener) {
        this.listeners.remove(listener);
    }

    private void launch(IResource resource, ILaunchShortcut launchShortcut) {
        StructuredSelection launchedSelection = new StructuredSelection((Object)resource);
        launchShortcut.launch((ISelection)launchedSelection, "debug");
    }

    private void notifyLaunchStarted(ILaunch[] launches) {
        for (LaunchListener listener : this.listeners) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                listener.launchStarted(launch);
                ++n2;
            }
        }
    }

    private void notifyLaunchTerminated(ILaunch[] launches) {
        for (LaunchListener listener : this.listeners) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                listener.launchStarted(launch);
                ++n2;
            }
        }
    }

    public static interface LaunchListener {
        public void launchStarted(ILaunch var1);

        public void launchTerminated(ILaunch var1);
    }
}

