/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.hover;

import com.github.sdbg.core.DartCore;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.hover.DebugTooltipControlCreator;
import com.github.sdbg.debug.ui.internal.objectinspector.ObjectInspectorContentProvider;
import com.github.sdbg.debug.ui.internal.presentation.SDBGDebugModelPresentation;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.variables.details.DefaultDetailPane;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneProxy;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class DebugTooltipControl
extends AbstractInformationControl
implements IInformationControlExtension2 {
    private static final String HEIGHT = "HEIGHT";
    private static final String WIDTH = "WIDTH";
    private static final String SASH_WEIGHT_TREE = "SashWeightTree";
    private static final String SASH_WEIGHT_DETAILS = "SashWeightDetails";
    private IVariable variable;
    private IPresentationContext presentationContext;
    private TreeViewer treeViewer;
    private SashForm sashForm;
    private Composite detailPaneComposite;
    private DetailPaneProxy detailPane;

    DebugTooltipControl(Shell parentShell, boolean resizeable) {
        super(parentShell, resizeable);
        this.create();
    }

    public Point computeSizeHint() {
        int y;
        int x;
        IDialogSettings settings = this.getDialogSettings(false);
        if (settings != null && (x = this.getIntSetting(settings, WIDTH)) > 0 && (y = this.getIntSetting(settings, HEIGHT)) > 0) {
            return new Point(x, y);
        }
        return super.computeSizeHint();
    }

    public void dispose() {
        this.persistSettings(this.getShell());
        this.presentationContext.dispose();
        super.dispose();
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return DebugTooltipControlCreator.newControlCreatorResizeable();
    }

    public boolean hasContents() {
        return this.variable != null;
    }

    public void setBackgroundColor(Color background) {
        super.setBackgroundColor(background);
        this.detailPaneComposite.setBackground(background);
        this.treeViewer.getTree().setBackground(background);
    }

    public void setFocus() {
        super.setFocus();
        this.treeViewer.getTree().setFocus();
    }

    public void setInput(Object input) {
        this.variable = (IVariable)input;
        this.treeViewer.setInput((Object)new Object[]{this.variable});
        TreeSelection selection = new TreeSelection(new TreePath(new Object[]{this.variable}));
        this.treeViewer.setSelection((ISelection)selection);
        this.detailPane.display((IStructuredSelection)selection);
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            this.persistSettings(this.getShell());
        }
        super.setVisible(visible);
    }

    protected void createContent(Composite parent) {
        StructuredViewer structuredViewer;
        this.sashForm = new SashForm(parent, parent.getStyle());
        this.sashForm.setOrientation(512);
        AbstractDebugView view = this.getViewToEmulate();
        this.presentationContext = new PresentationContext("org.eclipse.debug.ui.VariableView");
        if (view != null) {
            IPresentationContext copy = ((TreeModelViewer)view.getViewer()).getPresentationContext();
            String[] properties = copy.getProperties();
            int i = 0;
            while (i < properties.length) {
                String key = properties[i];
                this.presentationContext.setProperty(key, copy.getProperty(key));
                ++i;
            }
        }
        final SDBGDebugModelPresentation presentation = new SDBGDebugModelPresentation();
        this.treeViewer = new TreeViewer((Composite)this.sashForm, 66052);
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return presentation.getImage(element);
            }

            public String getText(Object element) {
                return presentation.getVariableDetailText((IVariable)element, null);
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new ObjectInspectorContentProvider());
        if (view != null && (structuredViewer = (StructuredViewer)view.getViewer()) != null) {
            ViewerFilter[] filters = structuredViewer.getFilters();
            int i = 0;
            while (i < filters.length) {
                this.treeViewer.addFilter(filters[i]);
                ++i;
            }
        }
        this.detailPaneComposite = SWTFactory.createComposite((Composite)this.sashForm, (int)1, (int)1, (int)1808);
        Layout layout = this.detailPaneComposite.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout gl = (GridLayout)layout;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
        }
        this.detailPane = new DetailPaneProxy((IDetailPaneContainer)new DetailPaneContainer());
        this.detailPane.display(null);
        this.treeViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DebugTooltipControl.this.detailPane.display((IStructuredSelection)DebugTooltipControl.this.treeViewer.getSelection());
            }
        });
        this.initSashWeights();
        if (DartCore.isMac()) {
            this.setBackgroundColor(this.getShell().getDisplay().getSystemColor(29));
        }
    }

    protected void initSashWeights() {
        int details;
        int tree;
        IDialogSettings settings = this.getDialogSettings(false);
        if (settings != null && (tree = this.getIntSetting(settings, SASH_WEIGHT_TREE)) > 0 && (details = this.getIntSetting(settings, SASH_WEIGHT_DETAILS)) > 0) {
            this.sashForm.setWeights(new int[]{tree, details});
        }
    }

    private IDialogSettings getDialogSettings(boolean create) {
        IDialogSettings settings = SDBGDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null & create) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return section;
    }

    private int getIntSetting(IDialogSettings settings, String key) {
        try {
            return settings.getInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private AbstractDebugView getViewToEmulate() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        AbstractDebugView expressionsView = (AbstractDebugView)page.findView("org.eclipse.debug.ui.ExpressionView");
        if (expressionsView != null && expressionsView.isVisible()) {
            return expressionsView;
        }
        AbstractDebugView variablesView = (AbstractDebugView)page.findView("org.eclipse.debug.ui.VariableView");
        if (variablesView != null && variablesView.isVisible()) {
            return variablesView;
        }
        if (expressionsView != null) {
            return expressionsView;
        }
        return variablesView;
    }

    private void persistSettings(Shell shell) {
        if (shell != null && !shell.isDisposed() && this.isResizable()) {
            IDialogSettings settings = this.getDialogSettings(true);
            Point size = shell.getSize();
            settings.put(WIDTH, size.x);
            settings.put(HEIGHT, size.y);
            int[] weights = this.sashForm.getWeights();
            settings.put(SASH_WEIGHT_TREE, weights[0]);
            settings.put(SASH_WEIGHT_DETAILS, weights[1]);
        }
    }

    private class DetailPaneContainer
    implements IDetailPaneContainer {
        public String getCurrentPaneID() {
            return DebugTooltipControl.this.detailPane.getCurrentPaneID();
        }

        public IStructuredSelection getCurrentSelection() {
            return (IStructuredSelection)DebugTooltipControl.this.treeViewer.getSelection();
        }

        public Composite getParentComposite() {
            return DebugTooltipControl.this.detailPaneComposite;
        }

        public IWorkbenchPartSite getWorkbenchPartSite() {
            return null;
        }

        public void paneChanged(String newPaneID) {
            if (newPaneID.equals(DefaultDetailPane.ID) && DartCore.isMac()) {
                DebugTooltipControl.this.detailPane.getCurrentControl().setBackground(DebugTooltipControl.this.getShell().getDisplay().getSystemColor(29));
            }
        }

        public void refreshDetailPaneContents() {
            DebugTooltipControl.this.detailPane.display(this.getCurrentSelection());
        }
    }
}

