/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.hover;

import com.github.sdbg.debug.core.model.IVariableResolver;
import com.github.sdbg.debug.ui.internal.hover.DebugTooltipControlCreator;
import com.github.sdbg.debug.ui.internal.presentation.SDBGDebugModelPresentation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class DebugHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private static SDBGDebugModelPresentation presentation = new SDBGDebugModelPresentation();

    private static String convertNewLines(String str) {
        if (str == null) {
            return str;
        }
        return str.trim().replaceAll("\n", "<br>");
    }

    private static String escapeHtml(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static SDBGDebugModelPresentation getModelPresentation() {
        return presentation;
    }

    private static String getVariableText(IVariable variable) {
        StringBuffer buffer = new StringBuffer();
        SDBGDebugModelPresentation modelPresentation = DebugHover.getModelPresentation();
        buffer.append("<p><pre>");
        String variableText = modelPresentation.getVariableDetailText(variable, null);
        buffer.append(DebugHover.convertNewLines(DebugHover.escapeHtml(DebugHover.shorten(variableText))));
        buffer.append("</pre></p>");
        modelPresentation.dispose();
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    private static String shorten(String str) {
        if (str == null) {
            return str;
        }
        return str.length() > 400 ? String.valueOf(str.substring(0, 400)) + "..." : str;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return DebugTooltipControlCreator.newControlCreator();
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object object = this.getHoverInfo2(textViewer, hoverRegion);
        if (object instanceof IVariable) {
            IVariable var = (IVariable)object;
            return DebugHover.getVariableText(var);
        }
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        IStackFrame frame = this.getFrame();
        if (frame != null && frame instanceof IVariableResolver) {
            IVariableResolver resolver = (IVariableResolver)frame;
            IDocument document = textViewer.getDocument();
            if (document != null) {
                try {
                    String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                    try {
                        IVariable variable = resolver.findVariable(variableName);
                        if (variable != null) {
                            return variable;
                        }
                    }
                    catch (DebugException debugException) {
                        return null;
                    }
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return this.findWord(textViewer.getDocument(), offset);
    }

    private IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    private IStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            return (IStackFrame)adaptable.getAdapter(IStackFrame.class);
        }
        return null;
    }
}

