/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.editors;

import com.github.sdbg.debug.ui.internal.editors.JsCodeScanner;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class JsSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private static final String[] CONTENT_TYPES = new String[]{"__dftl_partition_content_type", "__jsdoc", "__js_multiline_comment"};
    private final JsCodeScanner scanner = new JsCodeScanner();

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return CONTENT_TYPES;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler pr = new PresentationReconciler();
        pr.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.setDamagerRepairer(pr, new DefaultDamagerRepairer((ITokenScanner)this.scanner), "__dftl_partition_content_type");
        this.setDamagerRepairer(pr, new DefaultDamagerRepairer((ITokenScanner)new MultilineCommentScanner(this.scanner.getCommentAttribute())), "__js_multiline_comment");
        this.setDamagerRepairer(pr, new DefaultDamagerRepairer((ITokenScanner)new MultilineCommentScanner(this.scanner.getJsDocAttribute())), "__jsdoc");
        return pr;
    }

    private void setDamagerRepairer(PresentationReconciler pr, DefaultDamagerRepairer damagerRepairer, String tokenType) {
        pr.setDamager((IPresentationDamager)damagerRepairer, tokenType);
        pr.setRepairer((IPresentationRepairer)damagerRepairer, tokenType);
    }

    private static class MultilineCommentScanner
    extends BufferedRuleBasedScanner {
        public MultilineCommentScanner(TextAttribute attr) {
            this.setDefaultReturnToken((IToken)new Token((Object)attr));
        }
    }
}

