/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.editors;

import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class JsPartitionScanner
extends RuleBasedPartitionScanner {
    static final String PARTITIONING = "ChromiumJavaScriptPartitioning";
    static final String MULTILINE_COMMENT = "__js_multiline_comment";
    static final String JSDOC = "__jsdoc";
    static final String[] PARTITION_TYPES = new String[]{"__js_multiline_comment", "__jsdoc"};

    public JsPartitionScanner() {
        Token jsDocToken = new Token((Object)JSDOC);
        Token multilineCommentToken = new Token((Object)MULTILINE_COMMENT);
        this.setPredicateRules(new IPredicateRule[]{new EndOfLineRule("//", Token.UNDEFINED), new SingleLineRule("\"", "\"", Token.UNDEFINED, '\\'), new SingleLineRule("'", "'", Token.UNDEFINED, '\\'), new EmptyCommentPredicateRule((IToken)multilineCommentToken), new MultiLineRule("/**", "*/", (IToken)jsDocToken, '\u0000', true), new MultiLineRule("/*", "*/", (IToken)multilineCommentToken, '\u0000', true)});
    }

    private static class EmptyCommentDetector
    implements IWordDetector {
        private EmptyCommentDetector() {
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }
    }

    private static class EmptyCommentPredicateRule
    extends WordRule
    implements IPredicateRule {
        private final IToken successToken;

        public EmptyCommentPredicateRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.successToken = successToken;
            this.addWord("/**/", successToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return super.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.successToken;
        }
    }
}

